/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsFindAttributeDefsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestFindAttributeDefsRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcFindAttributeDefs {
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;
    private String scope;
    private Boolean splitScope;
    private String clientVersion;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Set<String> attributeDefNames = new LinkedHashSet<String>();
    private Set<String> attributeDefUuids = new LinkedHashSet<String>();
    private Set<Long> attributeDefIdIndexes = new LinkedHashSet<Long>();
    private Boolean ascending;
    private String privilegeName;
    private Integer pageNumber;
    private Integer pageSize;
    private String sortString;
    private Boolean pageIsCursor;
    private String pageLastCursorField;
    private String pageLastCursorFieldType;
    private Boolean pageCursorFieldIncludesLastRetrieved;

    public GcFindAttributeDefs assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcFindAttributeDefs assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcFindAttributeDefs assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcFindAttributeDefs assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcFindAttributeDefs assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcFindAttributeDefs assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcFindAttributeDefs assignScope(String theScope) {
        this.scope = theScope;
        return this;
    }

    public GcFindAttributeDefs assignSplitScope(Boolean theSplitScope) {
        this.splitScope = theSplitScope;
        return this;
    }

    public GcFindAttributeDefs assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcFindAttributeDefs addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcFindAttributeDefs addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcFindAttributeDefs assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.isBlank(this.scope) && GrouperClientUtils.length(this.attributeDefUuids) == 0 && GrouperClientUtils.length(this.attributeDefNames) == 0 && GrouperClientUtils.length(this.attributeDefIdIndexes) == 0) {
            throw new RuntimeException("Need to pass in a scope, or attributeDefNames or attributeDefUuids or attributeDefIdIndexes: " + this);
        }
    }

    public GcFindAttributeDefs assignPrivilege(String thePrivilegeName) {
        this.privilegeName = thePrivilegeName;
        return this;
    }

    public GcFindAttributeDefs assignAscending(Boolean isAscending) {
        this.ascending = isAscending;
        return this;
    }

    public GcFindAttributeDefs assignPageNumber(Integer thePageNumber) {
        this.pageNumber = thePageNumber;
        return this;
    }

    public GcFindAttributeDefs assignPageSize(Integer thePageSize) {
        this.pageSize = thePageSize;
        return this;
    }

    public GcFindAttributeDefs assignSortString(String theSortString) {
        this.sortString = theSortString;
        return this;
    }

    public GcFindAttributeDefs assignPageIsCursor(Boolean pageIsCursor) {
        this.pageIsCursor = pageIsCursor;
        return this;
    }

    public GcFindAttributeDefs assignPageLastCursorField(String pageLastCursorField) {
        this.pageLastCursorField = pageLastCursorField;
        return this;
    }

    public GcFindAttributeDefs assignPageLastCursorFieldType(String pageLastCursorFieldType) {
        this.pageLastCursorFieldType = pageLastCursorFieldType;
        return this;
    }

    public GcFindAttributeDefs assignPageCursorFieldIncludesLastRetrieved(Boolean pageCursorFieldIncludesLastRetrieved) {
        this.pageCursorFieldIncludesLastRetrieved = pageCursorFieldIncludesLastRetrieved;
        return this;
    }

    public WsFindAttributeDefsResults execute() {
        this.validate();
        WsFindAttributeDefsResults wsFindAttributeDefsResults = null;
        try {
            WsRestFindAttributeDefsRequest findAttributeDefs = new WsRestFindAttributeDefsRequest();
            findAttributeDefs.setActAsSubjectLookup(this.actAsSubject);
            if (this.params.size() > 0) {
                findAttributeDefs.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            ArrayList<WsAttributeDefLookup> attributeDefLookups = new ArrayList<WsAttributeDefLookup>();
            for (String attributeDefeName : this.attributeDefNames) {
                attributeDefLookups.add(new WsAttributeDefLookup(attributeDefeName, null));
            }
            for (String attributeDefUuid : this.attributeDefUuids) {
                attributeDefLookups.add(new WsAttributeDefLookup(null, attributeDefUuid));
            }
            for (Long attributeDefIdIndex : this.attributeDefIdIndexes) {
                attributeDefLookups.add(new WsAttributeDefLookup(null, null, attributeDefIdIndex.toString()));
            }
            findAttributeDefs.setWsAttributeDefLookups(GrouperClientUtils.toArray(attributeDefLookups, WsAttributeDefLookup.class));
            if (!GrouperClientUtils.isBlank(this.sortString)) {
                findAttributeDefs.setSortString(this.sortString);
            }
            if (this.ascending != null) {
                findAttributeDefs.setAscending(this.ascending != false ? "T" : "F");
            }
            if (this.pageNumber != null) {
                findAttributeDefs.setPageNumber(Integer.toString(this.pageNumber));
            }
            if (this.pageSize != null) {
                findAttributeDefs.setPageSize(Integer.toString(this.pageSize));
            }
            if (!GrouperClientUtils.isBlank(this.scope)) {
                findAttributeDefs.setScope(this.scope);
            }
            if (this.splitScope != null) {
                findAttributeDefs.setSplitScope(this.splitScope != false ? "T" : "F");
            }
            if (this.privilegeName != null) {
                findAttributeDefs.setPrivilegeName(this.privilegeName);
            }
            if (this.pageIsCursor != null) {
                findAttributeDefs.setPageIsCursor(this.pageIsCursor != false ? "T" : "F");
            }
            if (this.pageCursorFieldIncludesLastRetrieved != null) {
                findAttributeDefs.setPageCursorFieldIncludesLastRetrieved(this.pageCursorFieldIncludesLastRetrieved != false ? "T" : "F");
            }
            findAttributeDefs.setPageLastCursorField(this.pageLastCursorField);
            findAttributeDefs.setPageLastCursorFieldType(this.pageLastCursorFieldType);
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsFindAttributeDefsResults = (WsFindAttributeDefsResults)grouperClientWs.executeService("attributeDefs", findAttributeDefs, "findAttributeDefs", this.clientVersion, true);
            String resultMessage = wsFindAttributeDefsResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsFindAttributeDefsResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsFindAttributeDefsResults;
    }

    public GcFindAttributeDefs addAttributeDefName(String theAttributeDefName) {
        this.attributeDefNames.add(theAttributeDefName);
        return this;
    }

    public GcFindAttributeDefs addAttributeDefUuid(String theAttributeDefUuid) {
        this.attributeDefUuids.add(theAttributeDefUuid);
        return this;
    }

    public GcFindAttributeDefs addAttributeDefIdIndex(Long theAttributeDefIdIndex) {
        this.attributeDefIdIndexes.add(theAttributeDefIdIndex);
        return this;
    }
}

