/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefNameLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsAuditEntry;
import edu.internet2.middleware.grouperClient.ws.beans.WsAuditEntryColumn;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetAuditEntriesResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGetAuditEntriesRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class GcGetAuditEntries {
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;
    private String clientVersion;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Timestamp fromDate;
    private Timestamp toDate;
    private String auditType;
    private String auditActionId;
    private WsStemLookup wsStemLookup;
    private WsSubjectLookup wsSubjectLookup;
    private WsGroupLookup wsGroupLookup;
    private WsAttributeDefLookup wsAttributeDefLookup;
    private WsAttributeDefNameLookup wsAttributeDefNameLookup;
    private Integer pageSize;
    private String sortString;
    private Boolean ascending;
    private Boolean pageIsCursor;
    private String pageLastCursorField;
    private String pageLastCursorFieldType;
    private Boolean pageCursorFieldIncludesLastRetrieved;

    public GcGetAuditEntries assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcGetAuditEntries assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcGetAuditEntries assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcGetAuditEntries assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcGetAuditEntries assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcGetAuditEntries assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcGetAuditEntries assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcGetAuditEntries addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGetAuditEntries addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGetAuditEntries assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
    }

    public GcGetAuditEntries assignAuditType(String auditType) {
        this.auditType = auditType;
        return this;
    }

    public GcGetAuditEntries assignAuditActionId(String auditActionId) {
        this.auditActionId = auditActionId;
        return this;
    }

    public GcGetAuditEntries assignWsStemLookup(WsStemLookup theWsStemLookup) {
        this.wsStemLookup = theWsStemLookup;
        return this;
    }

    public GcGetAuditEntries assignWsSubjectLookup(WsSubjectLookup theWsSubjectLookup) {
        this.wsSubjectLookup = theWsSubjectLookup;
        return this;
    }

    public GcGetAuditEntries assignWsGroupLookup(WsGroupLookup theWsGroupLookup) {
        this.wsGroupLookup = theWsGroupLookup;
        return this;
    }

    public GcGetAuditEntries assignWsAttributeDefLookup(WsAttributeDefLookup theWsAttributeDefLookup) {
        this.wsAttributeDefLookup = theWsAttributeDefLookup;
        return this;
    }

    public GcGetAuditEntries assignWsAttributeDefNameLookup(WsAttributeDefNameLookup theWsAttributeDefNameLookup) {
        this.wsAttributeDefNameLookup = theWsAttributeDefNameLookup;
        return this;
    }

    public GcGetAuditEntries assignPageSize(Integer thePageSize) {
        this.pageSize = thePageSize;
        return this;
    }

    public GcGetAuditEntries assignSortString(String theSortString) {
        this.sortString = theSortString;
        return this;
    }

    public GcGetAuditEntries assignAscending(Boolean theAscending) {
        this.ascending = theAscending;
        return this;
    }

    public GcGetAuditEntries assignFromDate(Timestamp fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    public GcGetAuditEntries assignToDate(Timestamp toDate) {
        this.toDate = toDate;
        return this;
    }

    public WsGetAuditEntriesResults execute() {
        this.validate();
        WsGetAuditEntriesResults wsGetAuditEntriesResults = null;
        try {
            WsRestGetAuditEntriesRequest getAuditEntries = new WsRestGetAuditEntriesRequest();
            getAuditEntries.setActAsSubjectLookup(this.actAsSubject);
            getAuditEntries.setWsStemLookup(this.wsStemLookup);
            getAuditEntries.setWsGroupLookup(this.wsGroupLookup);
            getAuditEntries.setWsAttributeDefLookup(this.wsAttributeDefLookup);
            getAuditEntries.setWsAttributeDefNameLookup(this.wsAttributeDefNameLookup);
            getAuditEntries.setWsSubjectLookup(this.wsSubjectLookup);
            getAuditEntries.setAuditType(this.auditType);
            getAuditEntries.setAuditActionId(this.auditActionId);
            getAuditEntries.setPageSize(this.pageSize == null ? null : this.pageSize.toString());
            getAuditEntries.setSortString(this.sortString);
            getAuditEntries.setAscending(this.ascending == null ? null : (this.ascending != false ? "T" : "F"));
            if (this.params.size() > 0) {
                getAuditEntries.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            getAuditEntries.setFromDate(GrouperClientUtils.dateToString(this.fromDate));
            getAuditEntries.setToDate(GrouperClientUtils.dateToString(this.toDate));
            if (this.pageIsCursor != null) {
                getAuditEntries.setPageIsCursor(this.pageIsCursor != false ? "T" : "F");
            }
            if (this.pageCursorFieldIncludesLastRetrieved != null) {
                getAuditEntries.setPageCursorFieldIncludesLastRetrieved(this.pageCursorFieldIncludesLastRetrieved != false ? "T" : "F");
            }
            getAuditEntries.setPageLastCursorField(this.pageLastCursorField);
            getAuditEntries.setPageLastCursorFieldType(this.pageLastCursorFieldType);
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsGetAuditEntriesResults = (WsGetAuditEntriesResults)grouperClientWs.executeService("audits", getAuditEntries, "getAuditEntries", this.clientVersion, true);
            String resultMessage = wsGetAuditEntriesResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsGetAuditEntriesResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGetAuditEntriesResults;
    }

    public GcGetAuditEntries assignPageIsCursor(Boolean pageIsCursor) {
        this.pageIsCursor = pageIsCursor;
        return this;
    }

    public GcGetAuditEntries assignPageLastCursorField(String pageLastCursorField) {
        this.pageLastCursorField = pageLastCursorField;
        return this;
    }

    public GcGetAuditEntries assignPageLastCursorFieldType(String pageLastCursorFieldType) {
        this.pageLastCursorFieldType = pageLastCursorFieldType;
        return this;
    }

    public GcGetAuditEntries assignPageCursorFieldIncludesLastRetrieved(Boolean pageCursorFieldIncludesLastRetrieved) {
        this.pageCursorFieldIncludesLastRetrieved = pageCursorFieldIncludesLastRetrieved;
        return this;
    }

    public static void main(String[] args) {
        WsGetAuditEntriesResults wsGetAuditEntriesResults = new GcGetAuditEntries().assignAuditType("group").assignAuditActionId("addGroup").execute();
        WsAuditEntry wsAuditEntry = wsGetAuditEntriesResults.getWsAuditEntries()[0];
        for (WsAuditEntryColumn col : wsAuditEntry.getAuditEntryColumns()) {
            System.out.println(col);
        }
    }
}

