/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsMemberChangeSubject;
import edu.internet2.middleware.grouperClient.ws.beans.WsMemberChangeSubjectResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestMemberChangeSubjectRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcMemberChangeSubject {
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;
    private WsSubjectLookup oldSubjectLookup;
    private WsSubjectLookup newSubjectLookup;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Boolean deleteOldMember;
    private GcTransactionType txType;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private String clientVersion;

    public GcMemberChangeSubject assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcMemberChangeSubject assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcMemberChangeSubject assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcMemberChangeSubject assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcMemberChangeSubject assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcMemberChangeSubject assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcMemberChangeSubject assignOldSubjectLookup(WsSubjectLookup theOldSubjectLookup) {
        this.oldSubjectLookup = theOldSubjectLookup;
        return this;
    }

    public GcMemberChangeSubject assignNewSubjectLookup(WsSubjectLookup theNewSubjectLookup) {
        this.newSubjectLookup = theNewSubjectLookup;
        return this;
    }

    public GcMemberChangeSubject addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcMemberChangeSubject addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcMemberChangeSubject assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (this.oldSubjectLookup == null) {
            throw new RuntimeException("Old subject lookup is required: " + this);
        }
        if (this.newSubjectLookup == null) {
            throw new RuntimeException("New subject lookup is required: " + this);
        }
    }

    public GcMemberChangeSubject assignDeleteOldMember(boolean isDeleteOldMember) {
        this.deleteOldMember = isDeleteOldMember;
        return this;
    }

    public GcMemberChangeSubject assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public GcMemberChangeSubject addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcMemberChangeSubject assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public GcMemberChangeSubject assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public WsMemberChangeSubjectResults execute() {
        this.validate();
        WsMemberChangeSubjectResults wsMemberChangeSubjectResults = null;
        try {
            WsRestMemberChangeSubjectRequest memberChangeSubject = new WsRestMemberChangeSubjectRequest();
            memberChangeSubject.setActAsSubjectLookup(this.actAsSubject);
            WsMemberChangeSubject wsMemberChangeSubject = new WsMemberChangeSubject();
            if (this.deleteOldMember != null) {
                wsMemberChangeSubject.setDeleteOldMember(this.deleteOldMember != false ? "T" : "F");
            }
            wsMemberChangeSubject.setOldSubjectLookup(this.oldSubjectLookup);
            wsMemberChangeSubject.setNewSubjectLookup(this.newSubjectLookup);
            memberChangeSubject.setWsMemberChangeSubjects(new WsMemberChangeSubject[]{wsMemberChangeSubject});
            memberChangeSubject.setTxType(this.txType == null ? null : this.txType.name());
            if (this.includeSubjectDetail != null) {
                memberChangeSubject.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            if (this.subjectAttributeNames.size() > 0) {
                memberChangeSubject.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            if (this.params.size() > 0) {
                memberChangeSubject.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsMemberChangeSubjectResults = (WsMemberChangeSubjectResults)grouperClientWs.executeService("members", memberChangeSubject, "memberChangeSubject", this.clientVersion, false);
            String resultMessage = wsMemberChangeSubjectResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsMemberChangeSubjectResults, wsMemberChangeSubjectResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsMemberChangeSubjectResults;
    }
}

