/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.encryption;

import edu.internet2.middleware.grouperClient.encryption.GcEncryptionInterface;
import edu.internet2.middleware.grouperClient.encryption.GcGenerateKey;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.codec.binary.Base64;
import java.security.Key;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class GcSymmetricEncryptAesCbcPkcs5Padding
implements GcEncryptionInterface {
    public static void main(String[] args) {
        String secret = GcGenerateKey.generateKeyAes128base64();
        System.out.println("Key is: " + secret);
        String encrypted = new GcSymmetricEncryptAesCbcPkcs5Padding().encrypt(secret, "xyz");
        System.out.println("xyz encrypted: " + encrypted);
        String clear = new GcSymmetricEncryptAesCbcPkcs5Padding().decrypt(secret, encrypted);
        System.out.println("Clear (should be xyz): " + clear);
        encrypted = new GcSymmetricEncryptAesCbcPkcs5Padding().encrypt(secret, "xyz");
        System.out.println("xyz encrypted (should be different with different initialization vector): " + encrypted);
        clear = new GcSymmetricEncryptAesCbcPkcs5Padding().decrypt(secret, encrypted);
        System.out.println("Clear (should be xyz): " + clear);
    }

    @Override
    public String encrypt(String key, String data) {
        try {
            byte[] keyBytes = null;
            try {
                keyBytes = new Base64().decode(key.getBytes());
            }
            catch (Exception e) {
                throw new RuntimeException("Key must be 128 bit and encoded with base64", e);
            }
            if (keyBytes.length != 16) {
                throw new RuntimeException("Key must be 128 bit and encoded with base64");
            }
            SecretKeySpec skeySpec = new SecretKeySpec(keyBytes, "AES");
            byte[] iv = new byte[16];
            new Random().nextBytes(iv);
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)skeySpec, ivspec);
            byte[] encrypted = cipher.doFinal(data.getBytes());
            byte[] result = new byte[iv.length + encrypted.length];
            System.arraycopy(iv, 0, result, 0, iv.length);
            System.arraycopy(encrypted, 0, result, iv.length, encrypted.length);
            return new String(new Base64().encode(result), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String decrypt(String key, String encryptedData) {
        try {
            byte[] keyBytes = null;
            try {
                keyBytes = new Base64().decode(key.getBytes());
            }
            catch (Exception e) {
                throw new RuntimeException("Key must be 128 bit and encoded with base64", e);
            }
            if (keyBytes.length != 16) {
                throw new RuntimeException("Key must be 128 bit and encoded with base64");
            }
            SecretKeySpec skeySpec = new SecretKeySpec(keyBytes, "AES");
            byte[] iv = new byte[16];
            byte[] totalBytes = new Base64().decode(encryptedData.getBytes());
            byte[] encryptedDataBytes = new byte[totalBytes.length - iv.length];
            System.arraycopy(totalBytes, 0, iv, 0, iv.length);
            System.arraycopy(totalBytes, iv.length, encryptedDataBytes, 0, encryptedDataBytes.length);
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)skeySpec, ivspec);
            byte[] decrypted = cipher.doFinal(encryptedDataBytes);
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

