/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml;

import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.core.util.XmlHeaderAwareReader;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.StreamException;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.XppReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class XppDriver
extends AbstractXmlDriver {
    private static boolean xppLibraryPresent;

    public XppDriver() {
        super(new XmlFriendlyReplacer());
    }

    public XppDriver(XmlFriendlyReplacer replacer) {
        super(replacer);
    }

    @Override
    public HierarchicalStreamReader createReader(Reader xml) {
        this.loadLibrary();
        return new XppReader(xml, this.xmlFriendlyReplacer());
    }

    @Override
    public HierarchicalStreamReader createReader(InputStream in) {
        try {
            return this.createReader(new XmlHeaderAwareReader(in));
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    private void loadLibrary() {
        if (!xppLibraryPresent) {
            try {
                Class.forName("org.xmlpull.mxp1.MXParser");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("XPP3 pull parser library not present. Specify another driver. For example: new XStream(new DomDriver())");
            }
            xppLibraryPresent = true;
        }
    }

    @Override
    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.xmlFriendlyReplacer());
    }

    @Override
    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out));
    }
}

