/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.service.contexts;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.http.HttpMethod;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.service.contexts.SecurityContext;

public class SecurityContextBuilder {
    private List<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
    private Predicate<String> pathSelector = each -> true;
    private Predicate<HttpMethod> methodSelector;

    SecurityContextBuilder() {
    }

    public SecurityContextBuilder securityReferences(List<SecurityReference> securityReferences) {
        this.securityReferences = securityReferences;
        return this;
    }

    public SecurityContextBuilder forPaths(Predicate<String> selector) {
        this.pathSelector = selector;
        return this;
    }

    public SecurityContextBuilder forHttpMethods(Predicate<HttpMethod> methodSelector) {
        this.methodSelector = methodSelector;
        return this;
    }

    public SecurityContext build() {
        if (this.securityReferences == null) {
            this.securityReferences = new ArrayList<SecurityReference>();
        }
        if (this.methodSelector == null) {
            this.methodSelector = each -> true;
        }
        return new SecurityContext(this.securityReferences, this.pathSelector, this.methodSelector);
    }
}

