/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.liquibase;

import io.zonky.test.db.shaded.com.google.common.collect.ImmutableMap;
import io.zonky.test.db.util.ReflectionUtils;
import java.util.Map;
import java.util.Objects;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.core.io.ResourceLoader;

public class LiquibaseDescriptor {
    private final String beanName;
    private final ResourceLoader resourceLoader;
    private final String changeLog;
    private final String contexts;
    private final String labels;
    private final String tag;
    private final Map<String, String> parameters;
    private final String defaultSchema;
    private final boolean dropFirst;
    private final boolean shouldRun;

    ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public String getContexts() {
        return this.contexts;
    }

    public String getLabels() {
        return this.labels;
    }

    public String getTag() {
        return this.tag;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public boolean isDropFirst() {
        return this.dropFirst;
    }

    public boolean isShouldRun() {
        return this.shouldRun;
    }

    private LiquibaseDescriptor(String beanName, ResourceLoader resourceLoader, String changeLog, String contexts, String labels, String tag, Map<String, String> parameters, String defaultSchema, boolean dropFirst, boolean shouldRun) {
        this.beanName = beanName;
        this.resourceLoader = resourceLoader;
        this.changeLog = changeLog;
        this.contexts = contexts;
        this.labels = labels;
        this.tag = tag;
        this.parameters = parameters != null ? ImmutableMap.copyOf(parameters) : null;
        this.defaultSchema = defaultSchema;
        this.dropFirst = dropFirst;
        this.shouldRun = shouldRun;
    }

    public static LiquibaseDescriptor from(SpringLiquibase liquibase) {
        return new LiquibaseDescriptor(liquibase.getBeanName(), liquibase.getResourceLoader(), liquibase.getChangeLog(), liquibase.getContexts(), liquibase.getLabels(), liquibase.getTag(), (Map)ReflectionUtils.getField(liquibase, "parameters"), liquibase.getDefaultSchema(), liquibase.isDropFirst(), (Boolean)ReflectionUtils.getField(liquibase, "shouldRun"));
    }

    public void applyTo(SpringLiquibase liquibase) {
        liquibase.setBeanName(this.beanName);
        liquibase.setResourceLoader(this.resourceLoader);
        liquibase.setChangeLog(this.changeLog);
        liquibase.setContexts(this.contexts);
        liquibase.setLabels(this.labels);
        liquibase.setTag(this.tag);
        liquibase.setChangeLogParameters(this.parameters);
        liquibase.setDefaultSchema(this.defaultSchema);
        liquibase.setDropFirst(this.dropFirst);
        liquibase.setShouldRun(this.shouldRun);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiquibaseDescriptor that = (LiquibaseDescriptor)o;
        return this.dropFirst == that.dropFirst && this.shouldRun == that.shouldRun && Objects.equals(this.changeLog, that.changeLog) && Objects.equals(this.contexts, that.contexts) && Objects.equals(this.labels, that.labels) && Objects.equals(this.tag, that.tag) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.defaultSchema, that.defaultSchema);
    }

    public int hashCode() {
        return Objects.hash(this.changeLog, this.contexts, this.labels, this.tag, this.parameters, this.defaultSchema, this.dropFirst, this.shouldRun);
    }
}

