/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyClause;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLabeledStatement;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchArrowBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchArrowRHS;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchFallthroughBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.ASTYieldStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AbruptCompletionAnalysis {
    private AbruptCompletionAnalysis() {
    }

    static boolean canCompleteNormally(ASTStatement stmt) {
        return (Boolean)stmt.acceptVisitor(new ReachabilityVisitor(), new SubtreeState(f -> ReachabilityVisitor.VisitResult.Continue));
    }

    private static class SubtreeState {
        private final @Nullable SubtreeState parent;
        public boolean ignoreBreaksAndContinues;
        private Set<JavaNode> breakTargets = Collections.emptySet();
        private Set<ASTStatement> continueTargets = Collections.emptySet();
        private final Function<? super ASTStatement, ReachabilityVisitor.VisitResult> shouldContinue;

        SubtreeState(Function<? super ASTStatement, ReachabilityVisitor.VisitResult> shouldContinue) {
            this.parent = null;
            this.shouldContinue = shouldContinue;
        }

        SubtreeState(SubtreeState parent) {
            this.parent = parent;
            this.shouldContinue = parent.shouldContinue;
        }

        public boolean isIgnoreBreaksAndContinues() {
            return this.ignoreBreaksAndContinues || this.parent != null && this.parent.isIgnoreBreaksAndContinues();
        }

        boolean containsBreak(ASTStatement stmt) {
            return this.breakTargets.contains(stmt);
        }

        boolean containsContinue(ASTStatement stmt) {
            return this.continueTargets.contains(stmt);
        }

        void addBreak(ASTBreakStatement breakStatement) {
            this.addBreakImpl(breakStatement.getTarget());
        }

        void addYield(ASTYieldStatement yieldStmt) {
            this.addBreakImpl(yieldStmt.getYieldTarget());
        }

        private void addBreakImpl(JavaNode breakTargetStatement) {
            if (this.isIgnoreBreaksAndContinues()) {
                return;
            }
            if (this.breakTargets.isEmpty()) {
                this.breakTargets = new HashSet<JavaNode>();
            }
            this.breakTargets.add(breakTargetStatement);
            if (this.parent != null) {
                this.parent.addBreakImpl(breakTargetStatement);
            }
        }

        void addContinue(ASTContinueStatement continueStatement) {
            if (this.isIgnoreBreaksAndContinues()) {
                return;
            }
            if (this.continueTargets.isEmpty()) {
                this.continueTargets = new HashSet<ASTStatement>();
            }
            this.continueTargets.add(continueStatement.getTarget());
            if (this.parent != null) {
                this.parent.addContinue(continueStatement);
            }
        }
    }

    static final class ReachabilityVisitor
    extends JavaVisitorBase<SubtreeState, Boolean> {
        ReachabilityVisitor() {
        }

        @Override
        public Boolean visit(ASTBlock node, SubtreeState data) {
            this.recordReachableNode(node, data);
            return this.blockCanCompleteNormally(node, data);
        }

        private boolean blockCanCompleteNormally(Iterable<ASTStatement> node, SubtreeState data) {
            for (ASTStatement statement : node) {
                boolean canCompleteNormally = (Boolean)statement.acceptVisitor(this, new SubtreeState(data));
                if (canCompleteNormally) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitJavaNode(JavaNode node, SubtreeState data) {
            throw AssertionUtil.shouldNotReachHere((String)("Cannot visit non-statements: " + node));
        }

        @Override
        public Boolean visitStatement(ASTStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            return true;
        }

        @Override
        public Boolean visit(ASTThrowStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            return false;
        }

        @Override
        public Boolean visit(ASTReturnStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            return false;
        }

        @Override
        public Boolean visit(ASTBreakStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            data.addBreak(node);
            return false;
        }

        @Override
        public Boolean visit(ASTYieldStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            data.addYield(node);
            return false;
        }

        @Override
        public Boolean visit(ASTContinueStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            data.addContinue(node);
            return false;
        }

        @Override
        public Boolean visit(ASTIfStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            boolean thenCanCompleteNormally = (Boolean)node.getThenBranch().acceptVisitor(this, data);
            boolean elseCanCompleteNormally = node.getElseBranch() == null || (Boolean)node.getElseBranch().acceptVisitor(this, data) != false;
            return thenCanCompleteNormally || elseCanCompleteNormally;
        }

        @Override
        public Boolean visit(ASTSynchronizedStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            return node.getBody().acceptVisitor(this, data);
        }

        @Override
        public Boolean visit(ASTLabeledStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            boolean stmtCanCompleteNormally = (Boolean)node.getStatement().acceptVisitor(this, data);
            return stmtCanCompleteNormally || data.containsBreak(node);
        }

        @Override
        public Boolean visit(ASTForeachStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            node.getBody().acceptVisitor(this, data);
            return true;
        }

        @Override
        public Boolean visit(ASTDoStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            boolean bodyCompletesNormally = (Boolean)node.getBody().acceptVisitor(this, data);
            boolean isNotDoWhileTrue = !JavaAstUtils.isBooleanLiteral(node.getCondition(), true);
            return isNotDoWhileTrue && (bodyCompletesNormally || data.containsContinue(node)) || data.containsBreak(node);
        }

        @Override
        public Boolean visit(ASTSwitchStatement node, SubtreeState data) {
            boolean isExhaustive = node.hasDefaultCase();
            boolean completesNormally = true;
            boolean first = true;
            for (ASTSwitchBranch branch : node.getBranches()) {
                boolean branchCompletesNormally;
                if (branch instanceof ASTSwitchArrowBranch) {
                    ASTSwitchArrowRHS rhs = ((ASTSwitchArrowBranch)branch).getRightHandSide();
                    branchCompletesNormally = this.switchArrowBranchCompletesNormally(new SubtreeState(data), node, rhs);
                } else if (branch instanceof ASTSwitchFallthroughBranch) {
                    SubtreeState branchState;
                    NodeStream<ASTStatement> statements = ((ASTSwitchFallthroughBranch)branch).getStatements();
                    branchCompletesNormally = this.blockCanCompleteNormally((Iterable<ASTStatement>)statements, branchState = new SubtreeState(data)) || branchState.containsBreak(node);
                } else {
                    throw AssertionUtil.shouldNotReachHere((String)("Not a branch type: " + branch));
                }
                if (isExhaustive && first) {
                    completesNormally = branchCompletesNormally;
                    first = false;
                    continue;
                }
                completesNormally = completesNormally || branchCompletesNormally;
            }
            return completesNormally;
        }

        private boolean switchArrowBranchCompletesNormally(SubtreeState state, ASTSwitchStatement switchStmt, ASTSwitchArrowRHS rhs) {
            if (rhs instanceof ASTExpression) {
                return true;
            }
            if (rhs instanceof ASTThrowStatement) {
                return false;
            }
            if (rhs instanceof ASTBlock) {
                return ((ASTBlock)rhs).acceptVisitor(this, state) != false || state.containsBreak(switchStmt);
            }
            throw AssertionUtil.shouldNotReachHere((String)("not a branch RHS: " + rhs));
        }

        @Override
        public Boolean visit(ASTWhileStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            node.getBody().acceptVisitor(this, data);
            boolean isNotWhileTrue = !JavaAstUtils.isBooleanLiteral(node.getCondition(), true);
            return isNotWhileTrue || data.containsBreak(node);
        }

        @Override
        public Boolean visit(ASTForStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            node.getBody().acceptVisitor(this, data);
            boolean isNotForTrue = node.getCondition() != null && !JavaAstUtils.isBooleanLiteral(node.getCondition(), true);
            return isNotForTrue || data.containsBreak(node);
        }

        @Override
        public Boolean visit(ASTTryStatement node, SubtreeState data) {
            this.recordReachableNode(node, data);
            ASTFinallyClause finallyClause = node.getFinallyClause();
            boolean finallyCompletesNormally = true;
            if (finallyClause != null) {
                finallyCompletesNormally = finallyClause.getBody().acceptVisitor(this, new SubtreeState(data));
            }
            SubtreeState bodyState = this.tryClauseState(data, finallyCompletesNormally);
            boolean bodyCompletesNormally = node.getBody().acceptVisitor(this, bodyState);
            boolean anyCatchClauseCompletesNormally = false;
            for (ASTCatchClause catchClause : node.getCatchClauses()) {
                SubtreeState subtree = this.tryClauseState(data, finallyCompletesNormally);
                anyCatchClauseCompletesNormally |= catchClause.getBody().acceptVisitor(this, subtree).booleanValue();
            }
            return finallyCompletesNormally && (bodyCompletesNormally || anyCatchClauseCompletesNormally);
        }

        private SubtreeState tryClauseState(SubtreeState data, boolean finallyCompletesNormally) {
            SubtreeState bodyState = new SubtreeState(data);
            if (!finallyCompletesNormally) {
                bodyState.ignoreBreaksAndContinues = true;
            }
            return bodyState;
        }

        private void recordReachableNode(ASTStatement node, SubtreeState data) {
            if (data.shouldContinue.apply(node) == VisitResult.Abort) {
                throw ReachabilityVisitor.abortVisit();
            }
        }

        private static @NonNull VisitAbortedException abortVisit() {
            return VisitAbortedException.INSTANCE;
        }

        static class VisitAbortedException
        extends RuntimeException {
            static final VisitAbortedException INSTANCE = new VisitAbortedException();

            VisitAbortedException() {
            }
        }

        static enum VisitResult {
            Continue,
            Abort;

        }
    }
}

