/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast.internal;

import java.util.Locale;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAssertStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTGuard;
import net.sourceforge.pmd.lang.java.ast.ASTImplicitClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIntersectionType;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTModuleDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTNumericLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPattern;
import net.sourceforge.pmd.lang.java.ast.ASTPatternExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTReceiverParameter;
import net.sourceforge.pmd.lang.java.ast.ASTRecordDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTRecordPattern;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchArrowBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeArguments;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameters;
import net.sourceforge.pmd.lang.java.ast.ASTTypePattern;
import net.sourceforge.pmd.lang.java.ast.ASTUnnamedPattern;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.ASTYieldStatement;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.internal.ReportingStrategy;
import net.sourceforge.pmd.util.IteratorUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LanguageLevelChecker<T> {
    private static final Pattern SPACE_ESCAPE_PATTERN = Pattern.compile("(?<!\\\\)\\\\s");
    private final int jdkVersion;
    private final boolean preview;
    private final CheckVisitor visitor = new CheckVisitor();
    private final ReportingStrategy<T> reportingStrategy;

    public LanguageLevelChecker(int jdkVersion, boolean preview, ReportingStrategy<T> reportingStrategy) {
        this.jdkVersion = jdkVersion;
        this.preview = preview;
        this.reportingStrategy = reportingStrategy;
    }

    public int getJdkVersion() {
        return this.jdkVersion;
    }

    public boolean isPreviewEnabled() {
        return this.preview;
    }

    public void check(JavaNode node) {
        T accumulator = this.reportingStrategy.createAccumulator();
        node.descendantsOrSelf().crossFindBoundaries().filterIs(JavaNode.class).forEach(n -> n.acceptVisitor(this.visitor, accumulator));
        this.reportingStrategy.done(accumulator);
    }

    private boolean check(Node node, LanguageFeature feature, T acc) {
        String message = feature.errorMessage(this.jdkVersion, this.preview);
        if (message != null) {
            this.reportingStrategy.report(node, message, acc);
            return false;
        }
        return true;
    }

    private static String displayNameLower(String name) {
        return name.replaceAll("__", "-").replace('_', ' ').toLowerCase(Locale.ROOT);
    }

    private static String versionDisplayName(int jdk) {
        if (jdk < 8) {
            return "Java 1." + jdk;
        }
        return "Java " + jdk;
    }

    private final class CheckVisitor
    extends JavaVisitorBase<T, Void> {
        private CheckVisitor() {
        }

        protected Void visitChildren(Node node, T data) {
            throw new AssertionError((Object)"Shouldn't recurse");
        }

        public Void visitNode(Node node, T param) {
            return null;
        }

        @Override
        public Void visit(ASTImplicitClassDeclaration node, T data) {
            LanguageLevelChecker.this.check((Node)node, PreviewFeature.COMPACT_SOURCE_FILES_AND_INSTANCE_MAIN_METHODS, data);
            return null;
        }

        @Override
        public Void visit(ASTStringLiteral node, T data) {
            if (!node.isTextBlock() && SPACE_ESCAPE_PATTERN.matcher((CharSequence)node.getLiteralText()).find()) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.SPACE_STRING_ESCAPES, data);
            }
            if (node.isTextBlock()) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.TEXT_BLOCK_LITERALS, data);
            }
            return null;
        }

        @Override
        public Void visit(ASTImportDeclaration node, T data) {
            if (node.isStatic()) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.STATIC_IMPORT, data);
            }
            if (node.isModuleImport()) {
                LanguageLevelChecker.this.check((Node)node, PreviewFeature.MODULE_IMPORT_DECLARATIONS, data);
            }
            return null;
        }

        @Override
        public Void visit(ASTYieldStatement node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.YIELD_STATEMENTS, data);
            return null;
        }

        @Override
        public Void visit(ASTSwitchExpression node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.SWITCH_EXPRESSIONS, data);
            return null;
        }

        @Override
        public Void visit(ASTRecordDeclaration node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.RECORD_DECLARATIONS, data);
            return null;
        }

        @Override
        public Void visit(ASTConstructorCall node, T data) {
            if (node.usesDiamondTypeArgs() && LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.DIAMOND_TYPE_ARGUMENTS, data) && node.isAnonymousClass()) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.DIAMOND_TYPE_ARGUMENTS_FOR_ANONYMOUS_CLASSES, data);
            }
            return null;
        }

        @Override
        public Void visit(ASTTypeArguments node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.GENERICS, data);
            return null;
        }

        @Override
        public Void visit(ASTTypeParameters node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.GENERICS, data);
            return null;
        }

        @Override
        public Void visit(ASTFormalParameter node, T data) {
            if (node.isVarargs()) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.VARARGS_PARAMETERS, data);
            }
            return null;
        }

        @Override
        public Void visit(ASTReceiverParameter node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.RECEIVER_PARAMETERS, data);
            return null;
        }

        @Override
        public Void visit(ASTAnnotation node, T data) {
            if (node.getParent() instanceof ASTType) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.TYPE_ANNOTATIONS, data);
            } else {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.ANNOTATIONS, data);
            }
            return null;
        }

        @Override
        public Void visit(ASTForeachStatement node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.FOREACH_LOOPS, data);
            return null;
        }

        @Override
        public Void visit(ASTEnumDeclaration node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.ENUMS, data);
            this.visitTypeDecl((ASTTypeDeclaration)node, data);
            return null;
        }

        @Override
        public Void visit(ASTNumericLiteral node, T data) {
            int base = node.getBase();
            if (base == 16 && !node.isIntegral()) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.HEXADECIMAL_FLOATING_POINT_LITERALS, data);
            } else if (base == 2) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.BINARY_NUMERIC_LITERALS, data);
            } else if (node.getLiteralText().indexOf(95) >= 0) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.UNDERSCORES_IN_NUMERIC_LITERALS, data);
            }
            return null;
        }

        @Override
        public Void visit(ASTMethodReference node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.METHOD_REFERENCES, data);
            return null;
        }

        @Override
        public Void visit(ASTLambdaExpression node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.LAMBDA_EXPRESSIONS, data);
            return null;
        }

        @Override
        public Void visit(ASTMethodDeclaration node, T data) {
            if (node.hasModifiers(JModifier.DEFAULT, new JModifier[0])) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.DEFAULT_METHODS, data);
            }
            if (node.hasVisibility(ModifierOwner.Visibility.V_PRIVATE) && node.getEnclosingType() != null && node.getEnclosingType().isInterface()) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.PRIVATE_METHODS_IN_INTERFACES, data);
            }
            this.checkIdent(node, node.getName(), data);
            return null;
        }

        @Override
        public Void visit(ASTAssertStatement node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.ASSERT_STATEMENTS, data);
            return null;
        }

        @Override
        public Void visit(ASTTypePattern node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.TYPE_PATTERNS_IN_INSTANCEOF, data);
            return null;
        }

        @Override
        public Void visit(ASTRecordPattern node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.RECORD_PATTERNS, data);
            return null;
        }

        @Override
        public Void visit(ASTGuard node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.CASE_REFINEMENT, data);
            return null;
        }

        @Override
        public Void visit(ASTTryStatement node, T data) {
            if (node.isTryWithResources() && LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.TRY_WITH_RESOURCES, data)) {
                for (ASTResource resource : node.getResources()) {
                    if (!resource.isConciseResource()) continue;
                    LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.CONCISE_RESOURCE_SYNTAX, data);
                    break;
                }
            }
            return null;
        }

        @Override
        public Void visit(ASTIntersectionType node, T data) {
            if (node.getParent() instanceof ASTCastExpression) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.INTERSECTION_TYPES_IN_CASTS, data);
            }
            return null;
        }

        @Override
        public Void visit(ASTCatchClause node, T data) {
            if (node.getParameter().isMulticatch()) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.COMPOSITE_CATCH_CLAUSES, data);
            }
            return null;
        }

        @Override
        public Void visit(ASTSwitchLabel node, T data) {
            if (IteratorUtil.count(node.iterator()) > 1) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.COMPOSITE_CASE_LABEL, data);
            }
            if (node.isDefault() && 14 == node.getFirstToken().getKind()) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.PATTERNS_IN_SWITCH_STATEMENTS, data);
            }
            if (node.getFirstChild() instanceof ASTNullLiteral) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.NULL_IN_SWITCH_CASES, data);
            }
            if (node.getFirstChild() instanceof ASTPattern) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.PATTERNS_IN_SWITCH_STATEMENTS, data);
            }
            if (node.getFirstChild() instanceof ASTTypePattern && ((ASTTypePattern)node.getFirstChild()).getTypeNode() instanceof ASTPrimitiveType) {
                LanguageLevelChecker.this.check((Node)node, PreviewFeature.PRIMITIVE_TYPES_IN_PATTERNS_INSTANCEOF_AND_SWITCH, data);
            }
            return null;
        }

        @Override
        public Void visit(ASTModuleDeclaration node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.MODULE_DECLARATIONS, data);
            return null;
        }

        @Override
        public Void visit(ASTSwitchArrowBranch node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.SWITCH_RULES, data);
            return null;
        }

        @Override
        public Void visit(ASTVariableId node, T data) {
            this.checkIdent(node, node.getName(), data);
            return null;
        }

        @Override
        public Void visit(ASTUnnamedPattern node, T data) {
            LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.UNNAMED_VARIABLES_AND_PATTERNS, data);
            return null;
        }

        @Override
        public Void visitTypeDecl(ASTTypeDeclaration node, T data) {
            if (node.getModifiers().hasAnyExplicitly(JModifier.SEALED, JModifier.NON_SEALED)) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.SEALED_CLASSES, data);
            } else if (node.isLocal() && !node.isRegularClass()) {
                LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.STATIC_LOCAL_TYPE_DECLARATIONS, data);
            }
            String simpleName = node.getSimpleName();
            if ("var".equals(simpleName)) {
                LanguageLevelChecker.this.check((Node)node, Keywords.VAR_AS_A_TYPE_NAME, data);
            } else if ("yield".equals(simpleName)) {
                LanguageLevelChecker.this.check((Node)node, Keywords.YIELD_AS_A_TYPE_NAME, data);
            } else if ("record".equals(simpleName)) {
                LanguageLevelChecker.this.check((Node)node, Keywords.RECORD_AS_A_TYPE_NAME, data);
            } else if ("sealed".equals(simpleName)) {
                LanguageLevelChecker.this.check((Node)node, Keywords.SEALED_AS_A_TYPE_NAME, data);
            } else if ("permits".equals(simpleName)) {
                LanguageLevelChecker.this.check((Node)node, Keywords.PERMITS_AS_A_TYPE_NAME, data);
            }
            this.checkIdent(node, simpleName, data);
            return null;
        }

        @Override
        public Void visit(ASTConstructorDeclaration node, T data) {
            super.visit(node, data);
            if (node.getBody().descendants(ASTExplicitConstructorInvocation.class).nonEmpty() && !(node.getBody().getFirstChild() instanceof ASTExplicitConstructorInvocation)) {
                LanguageLevelChecker.this.check((Node)node, PreviewFeature.FLEXIBLE_CONSTRUCTOR_BODIES, data);
            }
            return null;
        }

        @Override
        public Void visit(ASTInfixExpression node, T data) {
            if (node.getOperator() == BinaryOp.INSTANCEOF) {
                ASTTypeExpression typeExpression;
                if (node.getRightOperand() instanceof ASTPatternExpression && node.getRightOperand().getFirstChild() instanceof ASTTypePattern) {
                    ASTTypePattern typePattern = (ASTTypePattern)node.getRightOperand().getFirstChild();
                    if (typePattern.getTypeNode() instanceof ASTPrimitiveType) {
                        LanguageLevelChecker.this.check((Node)node, PreviewFeature.PRIMITIVE_TYPES_IN_PATTERNS_INSTANCEOF_AND_SWITCH, data);
                    }
                } else if (node.getRightOperand() instanceof ASTTypeExpression && (typeExpression = (ASTTypeExpression)node.getRightOperand()).getTypeNode() instanceof ASTPrimitiveType) {
                    LanguageLevelChecker.this.check((Node)node, PreviewFeature.PRIMITIVE_TYPES_IN_PATTERNS_INSTANCEOF_AND_SWITCH, data);
                }
            }
            return (Void)super.visit(node, data);
        }

        private void checkIdent(JavaNode node, String simpleName, T acc) {
            if ("enum".equals(simpleName)) {
                LanguageLevelChecker.this.check((Node)node, Keywords.ENUM_AS_AN_IDENTIFIER, acc);
            } else if ("assert".equals(simpleName)) {
                LanguageLevelChecker.this.check((Node)node, Keywords.ASSERT_AS_AN_IDENTIFIER, acc);
            } else if ("_".equals(simpleName)) {
                if (LanguageLevelChecker.this.jdkVersion >= 21) {
                    LanguageLevelChecker.this.check((Node)node, RegularLanguageFeature.UNNAMED_VARIABLES_AND_PATTERNS, acc);
                } else {
                    LanguageLevelChecker.this.check((Node)node, Keywords.UNDERSCORE_AS_AN_IDENTIFIER, acc);
                }
            }
        }
    }

    static interface LanguageFeature {
        public @Nullable String errorMessage(int var1, boolean var2);
    }

    private static enum RegularLanguageFeature implements LanguageFeature
    {
        ASSERT_STATEMENTS(4),
        STATIC_IMPORT(5),
        ENUMS(5),
        GENERICS(5),
        ANNOTATIONS(5),
        FOREACH_LOOPS(5),
        VARARGS_PARAMETERS(5),
        HEXADECIMAL_FLOATING_POINT_LITERALS(5),
        UNDERSCORES_IN_NUMERIC_LITERALS(7),
        BINARY_NUMERIC_LITERALS(7),
        TRY_WITH_RESOURCES(7),
        COMPOSITE_CATCH_CLAUSES(7),
        DIAMOND_TYPE_ARGUMENTS(7),
        DEFAULT_METHODS(8),
        RECEIVER_PARAMETERS(8),
        TYPE_ANNOTATIONS(8),
        INTERSECTION_TYPES_IN_CASTS(8),
        LAMBDA_EXPRESSIONS(8),
        METHOD_REFERENCES(8),
        MODULE_DECLARATIONS(9),
        DIAMOND_TYPE_ARGUMENTS_FOR_ANONYMOUS_CLASSES(9),
        PRIVATE_METHODS_IN_INTERFACES(9),
        CONCISE_RESOURCE_SYNTAX(9),
        COMPOSITE_CASE_LABEL(14),
        SWITCH_EXPRESSIONS(14),
        SWITCH_RULES(14),
        YIELD_STATEMENTS(14),
        TEXT_BLOCK_LITERALS(15),
        SPACE_STRING_ESCAPES(15),
        RECORD_DECLARATIONS(16),
        TYPE_PATTERNS_IN_INSTANCEOF(16),
        STATIC_LOCAL_TYPE_DECLARATIONS(16),
        SEALED_CLASSES(17),
        PATTERNS_IN_SWITCH_STATEMENTS(21),
        NULL_IN_SWITCH_CASES(21),
        CASE_REFINEMENT(21),
        RECORD_PATTERNS(21),
        UNNAMED_VARIABLES_AND_PATTERNS(22);

        private final int minJdkLevel;

        private RegularLanguageFeature(int minJdkLevel) {
            this.minJdkLevel = minJdkLevel;
        }

        @Override
        public String errorMessage(int jdk, boolean preview) {
            if (jdk >= this.minJdkLevel) {
                return null;
            }
            return StringUtils.capitalize((String)LanguageLevelChecker.displayNameLower(this.name())) + " are a feature of " + LanguageLevelChecker.versionDisplayName(this.minJdkLevel) + ", you should select your language version accordingly";
        }
    }

    private static enum Keywords implements LanguageFeature
    {
        ASSERT_AS_AN_IDENTIFIER(4, "assert"),
        ENUM_AS_AN_IDENTIFIER(5, "enum"),
        UNDERSCORE_AS_AN_IDENTIFIER(9, "_"),
        VAR_AS_A_TYPE_NAME(10, "var"),
        YIELD_AS_A_TYPE_NAME(13, "yield"),
        RECORD_AS_A_TYPE_NAME(14, "record"),
        SEALED_AS_A_TYPE_NAME(15, "sealed"),
        PERMITS_AS_A_TYPE_NAME(15, "permits");

        private final int maxJdkVersion;
        private final String reserved;

        private Keywords(int minJdkVersion, String reserved) {
            this.maxJdkVersion = minJdkVersion;
            this.reserved = reserved;
        }

        @Override
        public String errorMessage(int jdk, boolean preview) {
            if (jdk < this.maxJdkVersion) {
                return null;
            }
            String s = LanguageLevelChecker.displayNameLower(this.name());
            String usageType = s.substring(s.indexOf(32) + 1);
            return "Since " + LanguageLevelChecker.versionDisplayName(this.maxJdkVersion) + ", '" + this.reserved + "' is reserved and cannot be used " + usageType;
        }
    }

    private static enum PreviewFeature implements LanguageFeature
    {
        COMPACT_SOURCE_FILES_AND_INSTANCE_MAIN_METHODS(22, 24, true),
        FLEXIBLE_CONSTRUCTOR_BODIES(22, 24, true),
        MODULE_IMPORT_DECLARATIONS(23, 24, true),
        PRIMITIVE_TYPES_IN_PATTERNS_INSTANCEOF_AND_SWITCH(23, 25, false);

        private final int minPreviewVersion;
        private final int maxPreviewVersion;
        private final boolean wasStandardized;

        private PreviewFeature(int minPreviewVersion, int maxPreviewVersion, boolean wasStandardized) {
            this.minPreviewVersion = minPreviewVersion;
            this.maxPreviewVersion = maxPreviewVersion;
            this.wasStandardized = wasStandardized;
        }

        @Override
        public String errorMessage(int jdk, boolean preview) {
            boolean isPreview;
            boolean isStandard = this.wasStandardized && jdk > this.maxPreviewVersion;
            boolean canBePreview = jdk >= this.minPreviewVersion && jdk <= this.maxPreviewVersion;
            boolean bl = isPreview = preview && canBePreview;
            if (isStandard || isPreview) {
                return null;
            }
            String message = StringUtils.capitalize((String)LanguageLevelChecker.displayNameLower(this.name()));
            message = this.wasStandardized ? message + " was only standardized in Java " + (this.maxPreviewVersion + 1) : (canBePreview ? message + " is a preview feature of JDK " + jdk : (this.minPreviewVersion == this.maxPreviewVersion ? message + " is a preview feature of JDK " + this.minPreviewVersion : message + " is a preview feature of JDKs " + this.minPreviewVersion + " to " + this.maxPreviewVersion));
            return message + ", you should select your language version accordingly";
        }
    }
}

