/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class UnusedPrivateFieldRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<List<String>> IGNORED_FIELD_NAMES = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"ignoredFieldNames").defaultValues((Object)"serialVersionUID", (Object[])new String[]{"serialPersistentFields"}).desc("Field Names that are ignored from the unused check")).build();
    private static final PropertyDescriptor<List<String>> REPORT_FOR_ANNOTATIONS_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"reportForAnnotations").desc("Fully qualified names of the annotation types that should be reported anyway. If an unused field has any of these annotations, then it is reported. If it has any other annotation, then it is still considered to used and is not reported.")).defaultValue(new ArrayList())).build();

    public UnusedPrivateFieldRule() {
        super(ASTTypeDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(IGNORED_FIELD_NAMES);
        this.definePropertyDescriptor(REPORT_FOR_ANNOTATIONS_DESCRIPTOR);
    }

    @Override
    public Object visitJavaNode(JavaNode node, Object data) {
        if (node instanceof ASTTypeDeclaration) {
            ASTTypeDeclaration type = (ASTTypeDeclaration)node;
            if (this.hasAnyAnnotation(type)) {
                return null;
            }
            for (ASTFieldDeclaration field : type.getDeclarations().filterIs(ASTFieldDeclaration.class)) {
                if (this.isIgnored(field)) continue;
                for (ASTVariableId varId : field.getVarIds()) {
                    if (!JavaAstUtils.isNeverUsed(varId)) continue;
                    this.asCtx(data).addViolation((Node)varId, new Object[]{varId.getName()});
                }
            }
        }
        return null;
    }

    private boolean isIgnored(ASTFieldDeclaration field) {
        return field.getVisibility() != ModifierOwner.Visibility.V_PRIVATE || this.isOK(field) || this.hasAnyAnnotation(field);
    }

    private boolean isOK(ASTFieldDeclaration field) {
        return field.getVarIds().any(it -> ((List)this.getProperty(IGNORED_FIELD_NAMES)).contains(it.getName()));
    }

    private boolean hasAnyAnnotation(Annotatable node) {
        NodeStream declaredAnnotations = node.getDeclaredAnnotations().filterNot(a -> TypeTestUtil.isA(SuppressWarnings.class, (TypeNode)a));
        for (String reportAnnotation : (List)this.getProperty(REPORT_FOR_ANNOTATIONS_DESCRIPTOR)) {
            for (ASTAnnotation annotation : declaredAnnotations) {
                if (!TypeTestUtil.isA(reportAnnotation, (TypeNode)annotation)) continue;
                return false;
            }
        }
        return !declaredAnnotations.isEmpty();
    }
}

