/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.time4j.PlainDate;
import net.time4j.calendar.HebrewCalendar;
import net.time4j.calendar.HebrewMonth;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.ChronoFunction;

public enum HebrewAnniversary {
    BIRTHDAY{

        @Override
        public ChronoFunction<CalendarDate, HebrewCalendar> inHebrewYear(int n) {
            return calendarDate -> {
                HebrewCalendar hebrewCalendar = HebrewAnniversary.convert(calendarDate);
                int n2 = hebrewCalendar.getDayOfMonth();
                if (hebrewCalendar.getMonth() == HebrewMonth.ADAR_II) {
                    return HebrewCalendar.ofBiblical(n, HebrewCalendar.isLeapYear(n) ? 13 : 12, n2);
                }
                HebrewMonth hebrewMonth = hebrewCalendar.getMonth();
                if (hebrewMonth == HebrewMonth.ADAR_I && !HebrewCalendar.isLeapYear(n)) {
                    hebrewMonth = HebrewMonth.ADAR_II;
                }
                if (n2 <= 29) {
                    return HebrewCalendar.of(n, hebrewMonth, n2);
                }
                return (HebrewCalendar)HebrewCalendar.of(n, hebrewMonth, 1).plus(CalendarDays.of(n2 - 1));
            };
        }
    }
    ,
    YAHRZEIT{

        @Override
        public ChronoFunction<CalendarDate, HebrewCalendar> inHebrewYear(int n) {
            return calendarDate -> {
                HebrewCalendar hebrewCalendar = HebrewAnniversary.convert(calendarDate);
                int n2 = hebrewCalendar.getYear();
                HebrewMonth hebrewMonth = hebrewCalendar.getMonth();
                int n3 = hebrewCalendar.getDayOfMonth();
                if (hebrewMonth == HebrewMonth.HESHVAN && n3 == 30 && HebrewCalendar.lengthOfMonth(n2 + 1, HebrewMonth.HESHVAN) == 29) {
                    return (HebrewCalendar)HebrewCalendar.of(n, HebrewMonth.KISLEV, 1).minus(CalendarDays.ONE);
                }
                if (hebrewMonth == HebrewMonth.KISLEV && n3 == 30 && HebrewCalendar.lengthOfMonth(n2 + 1, HebrewMonth.KISLEV) == 29) {
                    return (HebrewCalendar)HebrewCalendar.of(n, HebrewMonth.TEVET, 1).minus(CalendarDays.ONE);
                }
                if (hebrewMonth == HebrewMonth.ADAR_II && HebrewCalendar.isLeapYear(n2)) {
                    return HebrewCalendar.of(n, HebrewMonth.ADAR_II, n3);
                }
                if (hebrewMonth.getBiblicalValue(false) == 12 && n3 == 30 && !HebrewCalendar.isLeapYear(n)) {
                    return HebrewCalendar.of(n, HebrewMonth.SHEVAT, 30);
                }
                return (HebrewCalendar)HebrewCalendar.ofBiblical(n, hebrewMonth.getBiblicalValue(false), 1).plus(CalendarDays.of(n3 - 1));
            };
        }
    };


    public ChronoFunction<CalendarDate, HebrewCalendar> inHebrewYear(int n) {
        throw new AbstractMethodError();
    }

    public ChronoFunction<CalendarDate, List<PlainDate>> inGregorianYear(int n) {
        return calendarDate -> {
            HebrewCalendar hebrewCalendar = HebrewAnniversary.convert(calendarDate);
            int n2 = ((HebrewCalendar)PlainDate.of(n, 1, 1).transform(HebrewCalendar.axis())).getYear();
            PlainDate plainDate = (PlainDate)this.inHebrewYear(n2).apply(hebrewCalendar).transform(PlainDate.axis());
            PlainDate plainDate2 = (PlainDate)this.inHebrewYear(n2 + 1).apply(hebrewCalendar).transform(PlainDate.axis());
            ArrayList<PlainDate> arrayList = new ArrayList<PlainDate>(2);
            if (plainDate.getYear() == n) {
                arrayList.add(plainDate);
            }
            if (plainDate2.getYear() == n) {
                arrayList.add(plainDate2);
            }
            return Collections.unmodifiableList(arrayList);
        };
    }

    private static HebrewCalendar convert(CalendarDate calendarDate) {
        return calendarDate instanceof HebrewCalendar ? (HebrewCalendar)calendarDate : (HebrewCalendar)calendarDate.transform(HebrewCalendar.axis());
    }
}

