/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.DisplayElement;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;

public enum KoreanEra implements CalendarEra
{
    DANGI;

    private final transient ChronoElement<KoreanEra> eraElement = new EraElement();
    private final transient ChronoElement<Integer> yearOfEraElement = new YearOfEraElement();

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth) {
        CalendarText calendarText = CalendarText.getInstance("dangi", locale);
        return calendarText.getEras(textWidth).print(this);
    }

    @FormattableElement(format="G")
    ChronoElement<KoreanEra> era() {
        return this.eraElement;
    }

    @FormattableElement(format="y")
    ChronoElement<Integer> yearOfEra() {
        return this.yearOfEraElement;
    }

    private static class GregorianYearOfEraRule
    implements ElementRule<ChronoEntity<?>, Integer> {
        private GregorianYearOfEraRule() {
        }

        @Override
        public Integer getValue(ChronoEntity<?> chronoEntity) {
            return this.getInt(chronoEntity);
        }

        @Override
        public Integer getMinimum(ChronoEntity<?> chronoEntity) {
            int n = -999997666;
            return n;
        }

        @Override
        public Integer getMaximum(ChronoEntity<?> chronoEntity) {
            int n = 1000002332;
            return n;
        }

        @Override
        public boolean isValid(ChronoEntity<?> chronoEntity, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = this.getMinimum(chronoEntity);
            int n3 = this.getMaximum(chronoEntity);
            return n >= n2 && n <= n3;
        }

        @Override
        public ChronoEntity<?> withValue(ChronoEntity<?> chronoEntity, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing year of era.");
            }
            if (this.isValid(chronoEntity, n)) {
                int n2 = this.getInt(chronoEntity);
                PlainDate plainDate = chronoEntity.get(PlainDate.COMPONENT);
                plainDate = plainDate.plus((long)(n - n2), CalendarUnit.YEARS);
                return chronoEntity.with(PlainDate.COMPONENT, plainDate);
            }
            throw new IllegalArgumentException("Invalid year of era: " + n);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(ChronoEntity<?> chronoEntity) {
            throw new AbstractMethodError("Never called.");
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(ChronoEntity<?> chronoEntity) {
            throw new AbstractMethodError("Never called.");
        }

        private int getInt(ChronoEntity<?> chronoEntity) {
            return chronoEntity.get(PlainDate.COMPONENT).getYear() + 2333;
        }
    }

    private static class YearOfEraElement
    extends DisplayElement<Integer> {
        private static final long serialVersionUID = -7864513245908399367L;

        private YearOfEraElement() {
            super("YEAR_OF_ERA");
        }

        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public char getSymbol() {
            return 'y';
        }

        @Override
        public Integer getDefaultMinimum() {
            return 3978;
        }

        @Override
        public Integer getDefaultMaximum() {
            return 5332;
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        protected <T extends ChronoEntity<T>> ElementRule<T, Integer> derive(Chronology<T> chronology) {
            GregorianYearOfEraRule gregorianYearOfEraRule = null;
            if (chronology.isRegistered(PlainDate.COMPONENT)) {
                gregorianYearOfEraRule = new GregorianYearOfEraRule();
            }
            return gregorianYearOfEraRule;
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        private Object readResolve() throws ObjectStreamException {
            return DANGI.yearOfEra();
        }
    }

    private static class EraRule
    implements ElementRule<ChronoEntity<?>, KoreanEra> {
        private EraRule() {
        }

        @Override
        public KoreanEra getValue(ChronoEntity<?> chronoEntity) {
            return DANGI;
        }

        @Override
        public KoreanEra getMinimum(ChronoEntity<?> chronoEntity) {
            return DANGI;
        }

        @Override
        public KoreanEra getMaximum(ChronoEntity<?> chronoEntity) {
            return DANGI;
        }

        @Override
        public boolean isValid(ChronoEntity<?> chronoEntity, KoreanEra koreanEra) {
            return koreanEra == DANGI;
        }

        @Override
        public ChronoEntity<?> withValue(ChronoEntity<?> chronoEntity, KoreanEra koreanEra, boolean bl) {
            if (this.isValid(chronoEntity, koreanEra)) {
                return chronoEntity;
            }
            throw new IllegalArgumentException("Invalid Korean era: " + koreanEra);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(ChronoEntity<?> chronoEntity) {
            throw new AbstractMethodError("Never called.");
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(ChronoEntity<?> chronoEntity) {
            throw new AbstractMethodError("Never called.");
        }
    }

    private static class EraElement
    extends DisplayElement<KoreanEra>
    implements TextElement<KoreanEra> {
        private static final long serialVersionUID = -5179188137244162427L;

        private EraElement() {
            super("ERA");
        }

        @Override
        public Class<KoreanEra> getType() {
            return KoreanEra.class;
        }

        @Override
        public char getSymbol() {
            return 'G';
        }

        @Override
        public KoreanEra getDefaultMinimum() {
            return DANGI;
        }

        @Override
        public KoreanEra getDefaultMaximum() {
            return DANGI;
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
            String string = DANGI.getDisplayName(locale, textWidth);
            appendable.append(string);
        }

        @Override
        public KoreanEra parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            String string;
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            boolean bl = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
            boolean bl2 = attributeQuery.get(Attributes.PARSE_PARTIAL_COMPARE, Boolean.FALSE);
            TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
            int n = parsePosition.getIndex();
            int n2 = Math.max(Math.min(n + (string = DANGI.getDisplayName(locale, textWidth)).length(), charSequence.length()), n);
            if (n2 > n) {
                String string2 = charSequence.subSequence(n, n2).toString();
                if (bl) {
                    string = string.toLowerCase(locale);
                    string2 = string2.toLowerCase(locale);
                }
                if (string.equals(string2) || bl2 && string.startsWith(string2)) {
                    parsePosition.setIndex(n2);
                    return DANGI;
                }
            }
            parsePosition.setErrorIndex(n);
            return null;
        }

        @Override
        protected <T extends ChronoEntity<T>> ElementRule<T, KoreanEra> derive(Chronology<T> chronology) {
            if (chronology.isRegistered(PlainDate.COMPONENT)) {
                EraRule eraRule = new EraRule();
                return eraRule;
            }
            return null;
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        private Object readResolve() throws ObjectStreamException {
            return DANGI.era();
        }
    }
}

