/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.bahai;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.astro.SolarTime;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.calendar.bahai.BadiDivision;
import net.time4j.calendar.bahai.BadiEra;
import net.time4j.calendar.bahai.BadiIntercalaryDays;
import net.time4j.calendar.bahai.BadiMonth;
import net.time4j.calendar.bahai.FormattedContent;
import net.time4j.calendar.bahai.SPX;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.DisplayElement;
import net.time4j.format.Leniency;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="bahai")
public final class BadiCalendar
extends Calendrical<Unit, BadiCalendar> {
    public static final AttributeKey<FormattedContent> TEXT_CONTENT_ATTRIBUTE = Attributes.createKey("FORMATTED_CONTENT", FormattedContent.class);
    private static final SolarTime TEHERAN = SolarTime.ofLocation().easternLongitude(51, 25, 0.0).northernLatitude(35, 42, 0.0).usingCalculator(StdSolarCalculator.TIME4J).build();
    private static final int KULL_I_SHAI_INDEX = 0;
    private static final int VAHID_INDEX = 1;
    private static final int YEAR_INDEX = 2;
    private static final int DAY_OF_DIVISION_INDEX = 3;
    private static final int DAY_OF_YEAR_INDEX = 4;
    private static final int YOE_INDEX = 5;
    private static final int[] NEWROZ = new int[]{15785, 16150, 16515, 16881, 17246, 17611, 17976, 18342, 18707, 19072, 19437, 19803, 20168, 20533, 20898, 21263, 21629, 21994, 22359, 22724, 23090, 23455, 23820, 24185, 24551, 24916, 25281, 25646, 26012, 26377, 26742, 27107, 27473, 27838, 28203, 28568, 28934, 29299, 29664, 30029, 30395, 30760, 31125, 31490, 31855, 32221, 32586, 32951, 33316, 33682, 34047, 34412, 34777, 35143, 35508, 35873, 36238, 36604, 36969, 37334, 37699, 38065, 38430, 38795, 39160, 39526, 39891, 40256, 40621, 40987, 41352, 41717, 42082, 42448, 42813, 43178, 43543, 43908, 44274, 44639, 45004, 45369, 45735, 46100, 46465, 46830, 47196, 47561, 47926, 48291, 48657, 49022, 49387, 49752, 50118, 50483, 50848, 51213, 51579, 51944, 52309, 52674, 53040, 53405, 53770, 54135, 54501, 54866, 55231, 55596, 55961, 56327, 56692, 57057, 57422, 57788, 58153, 58518, 58883, 59249, 59614, 59979, 60344, 60710, 61075, 61440, 61805, 62171, 62536, 62901, 63266, 63632, 63997, 64362, 64727, 65093, 65458, 65823, 66188, 66554, 66919, 67284, 67649, 68014, 68380, 68745, 69110, 69475, 69841, 70206, 70571, 70936, 71302, 71667, 72032, 72397, 72763, 73128, 73493, 73858, 74224, 74589, 74954, 75319, 75685, 76050, 76415, 76780, 77146, 77511, 77876, 78241, 78607, 78972, 79337, 79702, 80067, 80433, 80798, 81163, 81528, 81894, 82259, 82624, 82989, 83355, 83720, 84085, 84450, 84816, 85181, 85546, 85911, 86277, 86642, 87007, 87372, 87738, 88103, 88468, 88833, 89199, 89564, 89929, 90294, 90660, 91025, 91390, 91755, 92120, 92486, 92851, 93216, 93581, 93947, 94312, 94677, 95042, 95408, 95773, 96138, 96503, 96869, 97234, 97599, 97964, 98330, 98695, 99060, 99425, 99791, 100156, 100521, 100886, 101252, 101617, 101982, 102347, 102713, 103078, 103443, 103808, 104173, 104539, 104904, 105269, 105634, 106000, 106365, 106730, 107095, 107461, 107826, 108191, 108556, 108922, 109287, 109652, 110017, 110383, 110748, 111113, 111478, 111844, 112209, 112574, 112939, 113305, 113670, 114035, 114400, 114766, 115131, 115496, 115861, 116226, 116592, 116957, 117322, 117687, 118053, 118418, 118783, 119148, 119514, 119879, 120244, 120609, 120975, 121340, 121705, 122070, 122436, 122801, 123166, 123531, 123897, 124262, 124627, 124992, 125358, 125723, 126088, 126453, 126819, 127184, 127549, 127914, 128279, 128645, 129010, 129375, 129740, 130106, 130471, 130836, 131201, 131567, 131932, 132297, 132662, 133028, 133393, 133758, 134123, 134489, 134854, 135219, 135584, 135950, 136315, 136680, 137045, 137411, 137776, 138141, 138506, 138872, 139237, 139602, 139967, 140332, 140698, 141063, 141428, 141793, 142159, 142524, 142889, 143254, 143620, 143985, 144350, 144715, 145081, 145446, 145811, 146176, 146542, 146907, 147272, 147637, 148003, 148368, 148733, 149098, 149464, 149829, 150194, 150559, 150924, 151290, 151655, 152020, 152385, 152751, 153116, 153481, 153846, 154212, 154577, 154942, 155307, 155673, 156038, 156403, 156768, 157134, 157499, 157864, 158229, 158595, 158960, 159325, 159690, 160056, 160421, 160786, 161151, 161517, 161882, 162247, 162612, 162978, 163343, 163708, 164073, 164438, 164804, 165169, 165534, 165899, 166265, 166630, 166995, 167360, 167726, 168091, 168456, 168821, 169187, 169552, 169917, 170282, 170648, 171013, 171378, 171743, 172109, 172474, 172839, 173204, 173570, 173935, 174300, 174665, 175031, 175396, 175761, 176126, 176491, 176857, 177222, 177587, 177952, 178318, 178683, 179048, 179413, 179779, 180144, 180509, 180874, 181240, 181605, 181970, 182335, 182701, 183066, 183431, 183796, 184162, 184527, 184892, 185257, 185623, 185988, 186353, 186718, 187084, 187449, 187814, 188179, 188544, 188910, 189275, 189640, 190005, 190371, 190736, 191101, 191466, 191832, 192197, 192562, 192927, 193293, 193658, 194023, 194388, 194754, 195119, 195484, 195849, 196215, 196580, 196945, 197310, 197676, 198041, 198406, 198771, 199136, 199502, 199867, 200232, 200597, 200963, 201328, 201693, 202058, 202424, 202789, 203154, 203519, 203885, 204250, 204615, 204980, 205346, 205711, 206076, 206441, 206807, 207172, 207537, 207902, 208268, 208633, 208998, 209363, 209729, 210094, 210459, 210824, 211189, 211555, 211920, 212285, 212650, 213016, 213381, 213746, 214111, 214477, 214842, 215207, 215572, 215938, 216303, 216668, 217033, 217399, 217764, 218129, 218494, 218860, 219225, 219590, 219955, 220321, 220686, 221051, 221416, 221782, 222147, 222512, 222877, 223242, 223608, 223973, 224338, 224703, 225069, 225434, 225799, 226164, 226530, 226895, 227260, 227625, 227991, 228356, 228721, 229086, 229452, 229817, 230182, 230547, 230913, 231278, 231643, 232008, 232374, 232739, 233104, 233469, 233835, 234200, 234565, 234930, 235295, 235661, 236026, 236391, 236756, 237122, 237487, 237852, 238217, 238583, 238948, 239313, 239678, 240044, 240409, 240774, 241139, 241505, 241870, 242235, 242600, 242966, 243331, 243696, 244061, 244427, 244792, 245157, 245522, 245888, 246253, 246618, 246983, 247348, 247714, 248079, 248444, 248809, 249175, 249540, 249905, 250270, 250636, 251001, 251366, 251731, 252097, 252462, 252827, 253192, 253558, 253923, 254288, 254653, 255019, 255384, 255749, 256114, 256480, 256845, 257210, 257575, 257941, 258306, 258671, 259036, 259401, 259767, 260132, 260497, 260862, 261228, 261593, 261958, 262323, 262689, 263054, 263419, 263784, 264150, 264515, 264880, 265245, 265611, 265976, 266341, 266706, 267072, 267437, 267802, 268167, 268533, 268898, 269263, 269628, 269994, 270359, 270724, 271089, 271454, 271820, 272185, 272550, 272915, 273281, 273646, 274011, 274376, 274742, 275107, 275472, 275837, 276203, 276568, 276933, 277298, 277664, 278029, 278394, 278759, 279125, 279490, 279855, 280220, 280586, 280951, 281316, 281681, 282047, 282412, 282777, 283142, 283507, 283873, 284238, 284603, 284968, 285334, 285699, 286064, 286429, 286795, 287160, 287525, 287890, 288256, 288621, 288986, 289351, 289717, 290082, 290447, 290812, 291178, 291543, 291908, 292273, 292639, 293004, 293369, 293734, 294100, 294465, 294830, 295195, 295560, 295926, 296291, 296656, 297021, 297387, 297752, 298117, 298482, 298848, 299213, 299578, 299943, 300309, 300674, 301039, 301404, 301770, 302135, 302500, 302865, 303231, 303596, 303961, 304326, 304692, 305057, 305422, 305787, 306153, 306518, 306883, 307248, 307613, 307979, 308344, 308709, 309074, 309440, 309805, 310170, 310535, 310901, 311266, 311631, 311996, 312362, 312727, 313092, 313457, 313823, 314188, 314553, 314918, 315284, 315649, 316014, 316379, 316745, 317110, 317475, 317840, 318206, 318571, 318936, 319301, 319666, 320032, 320397, 320762, 321127, 321493, 321858, 322223, 322588, 322954, 323319, 323684, 324049, 324415, 324780, 325145, 325510, 325876, 326241, 326606, 326971, 327337, 327702, 328067, 328432, 328798, 329163, 329528, 329893, 330259, 330624, 330989, 331354, 331719, 332085, 332450, 332815, 333180, 333546, 333911, 334276, 334641, 335007, 335372, 335737, 336102, 336468, 336833, 337198, 337563, 337929, 338294, 338659, 339024, 339390, 339755, 340120, 340485, 340851, 341216, 341581, 341946, 342312, 342677, 343042, 343407, 343772, 344138, 344503, 344868, 345233, 345599, 345964, 346329, 346694, 347060, 347425, 347790, 348155, 348521, 348886};
    @FormattableElement(format="G", dynamic=true)
    public static final ChronoElement<BadiEra> ERA = new StdEnumDateElement<BadiEra, BadiCalendar>("ERA", BadiCalendar.class, BadiEra.class, 'G'){

        @Override
        protected TextAccessor accessor(AttributeQuery attributeQuery, OutputContext outputContext, boolean bl) {
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
            return BadiEra.accessor(locale, textWidth);
        }
    };
    @FormattableElement(format="Y", alt="y", dynamic=true)
    public static final StdCalendarElement<Integer, BadiCalendar> YEAR_OF_ERA = new StdIntegerDateElement<BadiCalendar>("YEAR_OF_ERA", BadiCalendar.class, 1, 1083, 'Y');
    @FormattableElement(format="K", alt="k", dynamic=true)
    public static final ChronoElement<Integer> KULL_I_SHAI = new StdIntegerDateElement<BadiCalendar>("KULL_I_SHAI", BadiCalendar.class, 1, 3, 'K'){

        @Override
        public String getDisplayName(Locale locale) {
            return CalendarText.getInstance("bahai", locale).getTextForms().get("K");
        }
    };
    @FormattableElement(format="V", alt="v", dynamic=true)
    public static final StdCalendarElement<Integer, BadiCalendar> VAHID = new StdIntegerDateElement<BadiCalendar>("VAHID", BadiCalendar.class, 1, 19, 'V'){

        @Override
        public String getDisplayName(Locale locale) {
            return CalendarText.getInstance("bahai", locale).getTextForms().get("V");
        }
    };
    @FormattableElement(format="X", alt="x", dynamic=true)
    public static final TextElement<Integer> YEAR_OF_VAHID = YOV.SINGLETON;
    @FormattableElement(format="M", alt="m", dynamic=true)
    public static final StdCalendarElement<BadiMonth, BadiCalendar> MONTH_OF_YEAR = MonthElement.SINGLETON;
    @FormattableElement(format="A", dynamic=true)
    public static final ChronoElement<BadiIntercalaryDays> AYYAM_I_HA = IntercalaryAccess.SINGLETON;
    @FormattableElement(format="D", alt="d", dynamic=true)
    public static final StdCalendarElement<Integer, BadiCalendar> DAY_OF_DIVISION = new StdIntegerDateElement<BadiCalendar>("DAY_OF_DIVISION", BadiCalendar.class, 1, 19, 'D');
    public static final StdCalendarElement<Integer, BadiCalendar> DAY_OF_YEAR = new StdIntegerDateElement<BadiCalendar>("DAY_OF_YEAR", BadiCalendar.class, 1, 365, '\u0000');
    @FormattableElement(format="E", dynamic=true)
    public static final StdCalendarElement<Weekday, BadiCalendar> DAY_OF_WEEK = DowElement.SINGLETON;
    private static final CalendarSystem<BadiCalendar> CALSYS = new Transformer();
    private static final TimeAxis<Unit, BadiCalendar> ENGINE;
    private static final long serialVersionUID = 7091925253640345123L;
    private final transient int major;
    private final transient int cycle;
    private final transient int year;
    private final transient int division;
    private final transient int day;

    private BadiCalendar(int n, int n2, int n3, int n4, int n5) {
        this.major = n;
        this.cycle = n2;
        this.year = n3;
        this.division = n4;
        this.day = n5;
    }

    public static BadiCalendar ofComplete(int n, int n2, int n3, BadiDivision badiDivision, int n4) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Major cycle (kull-i-shai) out of range 1-3: " + n);
        }
        if (n2 < 1 || n2 > 19) {
            throw new IllegalArgumentException("Vahid cycle out of range 1-19: " + n2);
        }
        if (n3 < 1 || n3 > 19) {
            throw new IllegalArgumentException("Year of vahid out of range 1-19: " + n3);
        }
        if (badiDivision instanceof BadiMonth) {
            if (n4 < 1 || n4 > 19) {
                throw new IllegalArgumentException("Day out of range 1-19: " + n4);
            }
            return new BadiCalendar(n, n2, n3, ((BadiMonth)BadiMonth.class.cast(badiDivision)).getValue(), n4);
        }
        if (badiDivision == BadiIntercalaryDays.AYYAM_I_HA) {
            int n5;
            int n6 = n5 = BadiCalendar.isLeapYear(n, n2, n3) ? 5 : 4;
            if (n4 < 1 || n4 > n5) {
                throw new IllegalArgumentException("Day out of range 1-" + n5 + ": " + n4);
            }
            return new BadiCalendar(n, n2, n3, 0, n4);
        }
        if (badiDivision == null) {
            throw new NullPointerException("Missing Badi month or Ayyam-i-Ha.");
        }
        throw new IllegalArgumentException("Invalid implementation of Badi division: " + badiDivision);
    }

    public static BadiCalendar ofComplete(BadiEra badiEra, int n, BadiDivision badiDivision, int n2) {
        if (badiEra == null) {
            throw new NullPointerException("Missing Bahai era.");
        }
        if (n < 1 || n > 1083) {
            throw new IllegalArgumentException("Year of era out of range 1-1083: " + n);
        }
        BadiCalendar badiCalendar = (BadiCalendar)((BadiCalendar)BadiCalendar.axis().getMinimum()).with((ChronoElement<Integer>)YEAR_OF_ERA, n);
        int n3 = badiCalendar.getKullishai();
        int n4 = badiCalendar.getVahid();
        int n5 = badiCalendar.getYearOfVahid();
        if (badiDivision instanceof BadiMonth) {
            if (n2 < 1 || n2 > 19) {
                throw new IllegalArgumentException("Day out of range 1-19: " + n2);
            }
            return new BadiCalendar(n3, n4, n5, ((BadiMonth)BadiMonth.class.cast(badiDivision)).getValue(), n2);
        }
        if (badiDivision == BadiIntercalaryDays.AYYAM_I_HA) {
            int n6;
            int n7 = n6 = BadiCalendar.isLeapYear(n3, n4, n5) ? 5 : 4;
            if (n2 < 1 || n2 > n6) {
                throw new IllegalArgumentException("Day out of range 1-" + n6 + ": " + n2);
            }
            return new BadiCalendar(n3, n4, n5, 0, n2);
        }
        if (badiDivision == null) {
            throw new NullPointerException("Missing Badi month or Ayyam-i-Ha.");
        }
        throw new IllegalArgumentException("Invalid implementation of Badi division: " + badiDivision);
    }

    public static BadiCalendar of(int n, int n2, BadiMonth badiMonth, int n3) {
        return BadiCalendar.ofComplete(1, n, n2, badiMonth, n3);
    }

    public static BadiCalendar of(int n, int n2, int n3, int n4) {
        return BadiCalendar.ofComplete(1, n, n2, BadiMonth.valueOf(n3), n4);
    }

    public static BadiCalendar ofIntercalary(int n, int n2, int n3) {
        return BadiCalendar.ofComplete(1, n, n2, BadiIntercalaryDays.AYYAM_I_HA, n3);
    }

    public static BadiCalendar nowInSystemTime() {
        return (BadiCalendar)SystemClock.inLocalView().now(BadiCalendar.axis());
    }

    public int getKullishai() {
        return this.major;
    }

    public int getVahid() {
        return this.cycle;
    }

    public int getYearOfVahid() {
        return this.year;
    }

    public int getYearOfEra() {
        return this.getRelatedGregorianYear() - 1843;
    }

    public BadiMonth getMonth() {
        if (this.division == 0) {
            throw new ChronoException("Intercalary days (Ayyam-i-Ha) do not represent any month: " + this.toString());
        }
        return BadiMonth.valueOf(this.division);
    }

    public BadiDivision getDivision() {
        return this.isIntercalaryDay() ? BadiIntercalaryDays.AYYAM_I_HA : this.getMonth();
    }

    public int getDayOfDivision() {
        return this.day;
    }

    public Weekday getDayOfWeek() {
        long l = CALSYS.transform(this);
        return Weekday.valueOf(MathUtils.floorModulo(l + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        switch (this.division) {
            case 0: {
                return 342 + this.day;
            }
            case 19: {
                return 342 + (this.isLeapYear() ? 5 : 4) + this.day;
            }
        }
        return (this.division - 1) * 19 + this.day;
    }

    public boolean isIntercalaryDay() {
        return this.division == 0;
    }

    public boolean hasMonth() {
        return this.division > 0;
    }

    public boolean isLeapYear() {
        return BadiCalendar.isLeapYear(this.major, this.cycle, this.year);
    }

    public static boolean isLeapYear(int n, int n2, int n3) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Major cycle (kull-i-shai) out of range 1-3: " + n);
        }
        if (n2 < 1 || n2 > 19) {
            throw new IllegalArgumentException("Vahid cycle out of range 1-19: " + n2);
        }
        if (n3 < 1 || n3 > 19) {
            throw new IllegalArgumentException("Year out of range 1-19: " + n3);
        }
        int n4 = BadiCalendar.getRelatedGregorianYear(n, n2, n3);
        if (n4 < 2015) {
            return GregorianMath.isLeapYear(n4 + 1);
        }
        int n5 = n4 - 2015;
        return NEWROZ[n5 + 1] - NEWROZ[n5] == 366;
    }

    public static boolean isValid(int n, int n2, int n3, BadiDivision badiDivision, int n4) {
        if (n < 1 || n > 3) {
            return false;
        }
        if (n2 < 1 || n2 > 19) {
            return false;
        }
        if (n3 < 1 || n3 > 19) {
            return false;
        }
        if (badiDivision instanceof BadiMonth) {
            return n4 >= 1 && n4 <= 19;
        }
        if (badiDivision == BadiIntercalaryDays.AYYAM_I_HA) {
            return n4 >= 1 && n4 <= (BadiCalendar.isLeapYear(n, n2, n3) ? 5 : 4);
        }
        return false;
    }

    public GeneralTimestamp<BadiCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<BadiCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of(n, n2));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BadiCalendar) {
            BadiCalendar badiCalendar = (BadiCalendar)object;
            return this.major == badiCalendar.major && this.cycle == badiCalendar.cycle && this.year == badiCalendar.year && this.division == badiCalendar.division && this.day == badiCalendar.day;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (361 * this.major + 19 * this.cycle + this.year) * 512 + this.division * 19 + this.day;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("Bahai-");
        stringBuilder.append(this.major);
        stringBuilder.append('-');
        stringBuilder.append(this.cycle);
        stringBuilder.append('-');
        stringBuilder.append(this.year);
        stringBuilder.append('-');
        if (this.division == 0) {
            stringBuilder.append("Ayyam-i-Ha-");
        } else {
            stringBuilder.append(this.division);
            stringBuilder.append('-');
        }
        stringBuilder.append(this.day);
        return stringBuilder.toString();
    }

    @Override
    public boolean contains(ChronoElement<?> chronoElement) {
        if (chronoElement == MONTH_OF_YEAR) {
            return this.hasMonth();
        }
        if (chronoElement == AYYAM_I_HA) {
            return this.isIntercalaryDay();
        }
        if (this.getRegisteredElements().contains(chronoElement)) {
            return true;
        }
        return BadiCalendar.isAccessible(this, chronoElement);
    }

    @Override
    public <V> boolean isValid(ChronoElement<V> chronoElement, V v) {
        if (chronoElement == MONTH_OF_YEAR || chronoElement == AYYAM_I_HA || chronoElement == ERA) {
            return v != null;
        }
        return super.isValid(chronoElement, v);
    }

    public static TimeAxis<Unit, BadiCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<Unit, BadiCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected BadiCalendar getContext() {
        return this;
    }

    private static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Weekday.SATURDAY, 1, Weekday.SATURDAY, Weekday.SUNDAY);
    }

    private int getRelatedGregorianYear() {
        return BadiCalendar.getRelatedGregorianYear(this.major, this.cycle, this.year);
    }

    private static int getRelatedGregorianYear(int n, int n2, int n3) {
        return (n - 1) * 361 + (n2 - 1) * 19 + n3 + 1843;
    }

    private BadiCalendar withDayOfYear(int n) {
        int n2;
        int n3;
        if (n <= 342) {
            n3 = (n - 1) / 19 + 1;
            n2 = (n - 1) % 19 + 1;
        } else if (n <= 342 + (this.isLeapYear() ? 5 : 4)) {
            n3 = 0;
            n2 = n - 342;
        } else {
            n3 = 19;
            n2 = n - (this.isLeapYear() ? 5 : 4) - 342;
        }
        return new BadiCalendar(this.major, this.cycle, this.year, n3, n2);
    }

    private static <V> boolean isAccessible(BadiCalendar badiCalendar, ChronoElement<V> chronoElement) {
        try {
            return badiCalendar.isValid(chronoElement, badiCalendar.get(chronoElement));
        }
        catch (ChronoException chronoException) {
            return false;
        }
    }

    private static Locale getLocale(AttributeQuery attributeQuery) {
        return attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
    }

    private static FormattedContent getFormattedContent(AttributeQuery attributeQuery) {
        return attributeQuery.get(TEXT_CONTENT_ATTRIBUTE, FormattedContent.TRANSCRIPTION);
    }

    private Object writeReplace() {
        return new SPX(this, 19);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        TimeAxis.Builder<Unit, BadiCalendar> builder = ((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(Unit.class, BadiCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)ERA, (ElementRule)new EraRule())).appendElement(YEAR_OF_ERA, new IntegerRule(5), Unit.YEARS).appendElement((ChronoElement)KULL_I_SHAI, (ElementRule)new IntegerRule(0))).appendElement(VAHID, new IntegerRule(1), Unit.VAHID_CYCLES).appendElement(YEAR_OF_VAHID, new IntegerRule(2), Unit.YEARS).appendElement(MONTH_OF_YEAR, new MonthRule(), Unit.MONTHS).appendElement((ChronoElement)AYYAM_I_HA, (ElementRule)IntercalaryAccess.SINGLETON)).appendElement(DAY_OF_DIVISION, new IntegerRule(3), Unit.DAYS).appendElement(DAY_OF_YEAR, new IntegerRule(4), Unit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule(), Unit.DAYS).appendUnit(Unit.VAHID_CYCLES, new FUnitRule(Unit.VAHID_CYCLES), Unit.VAHID_CYCLES.getLength(), Collections.singleton(Unit.YEARS)).appendUnit(Unit.YEARS, new FUnitRule(Unit.YEARS), Unit.YEARS.getLength(), Collections.singleton(Unit.VAHID_CYCLES)).appendUnit(Unit.MONTHS, new FUnitRule(Unit.MONTHS), Unit.MONTHS.getLength()).appendUnit(Unit.WEEKS, new FUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit(Unit.DAYS, new FUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS));
        ENGINE = builder.build();
    }

    private static class FUnitRule
    implements UnitRule<BadiCalendar> {
        private final Unit unit;

        FUnitRule(Unit unit) {
            this.unit = unit;
        }

        @Override
        public BadiCalendar addTo(BadiCalendar badiCalendar, long l) {
            switch (this.unit) {
                case VAHID_CYCLES: {
                    l = MathUtils.safeMultiply(l, 19L);
                }
                case YEARS: {
                    long l2 = MathUtils.safeAdd((long)FUnitRule.elapsedYears(badiCalendar), l);
                    int n = MathUtils.safeCast(MathUtils.floorDivide(l2, 361)) + 1;
                    int n2 = MathUtils.floorModulo(l2, 361);
                    int n3 = MathUtils.floorDivide(n2, 19) + 1;
                    int n4 = MathUtils.floorModulo(n2, 19) + 1;
                    int n5 = badiCalendar.day;
                    if (badiCalendar.day == 5 && !BadiCalendar.isLeapYear(n, n3, n4)) {
                        n5 = 4;
                    }
                    return BadiCalendar.ofComplete(n, n3, n4, badiCalendar.getDivision(), n5);
                }
                case MONTHS: {
                    long l3 = MathUtils.safeAdd((long)FUnitRule.elapsedMonths(badiCalendar), l);
                    int n = MathUtils.safeCast(MathUtils.floorDivide(l3, 6859)) + 1;
                    int n6 = MathUtils.floorModulo(l3, 6859);
                    int n7 = MathUtils.floorDivide(n6, 361) + 1;
                    n6 = MathUtils.floorModulo(n6, 361);
                    int n8 = MathUtils.floorDivide(n6, 19) + 1;
                    int n9 = MathUtils.floorModulo(n6, 19) + 1;
                    int n10 = badiCalendar.isIntercalaryDay() ? 19 : badiCalendar.day;
                    return BadiCalendar.ofComplete(n, n7, n8, BadiMonth.valueOf(n9), n10);
                }
                case WEEKS: {
                    l = MathUtils.safeMultiply(l, 7L);
                }
                case DAYS: {
                    long l4 = MathUtils.safeAdd(CALSYS.transform(badiCalendar), l);
                    return (BadiCalendar)CALSYS.transform(l4);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        @Override
        public long between(BadiCalendar badiCalendar, BadiCalendar badiCalendar2) {
            switch (this.unit) {
                case VAHID_CYCLES: {
                    return Unit.YEARS.between(badiCalendar, badiCalendar2) / 19L;
                }
                case YEARS: {
                    int n = FUnitRule.elapsedYears(badiCalendar2) - FUnitRule.elapsedYears(badiCalendar);
                    if (n > 0 && badiCalendar2.getDayOfYear() < badiCalendar.getDayOfYear()) {
                        --n;
                    } else if (n < 0 && badiCalendar2.getDayOfYear() > badiCalendar.getDayOfYear()) {
                        ++n;
                    }
                    return n;
                }
                case MONTHS: {
                    int n;
                    long l = FUnitRule.elapsedMonths(badiCalendar2) - FUnitRule.elapsedMonths(badiCalendar);
                    int n2 = badiCalendar.isIntercalaryDay() ? badiCalendar.day + 19 : badiCalendar.day;
                    int n3 = n = badiCalendar2.isIntercalaryDay() ? badiCalendar2.day + 19 : badiCalendar2.day;
                    if (l > 0L && n < n2) {
                        --l;
                    } else if (l < 0L && n > n2) {
                        ++l;
                    }
                    return l;
                }
                case WEEKS: {
                    return Unit.DAYS.between(badiCalendar, badiCalendar2) / 7L;
                }
                case DAYS: {
                    return CALSYS.transform(badiCalendar2) - CALSYS.transform(badiCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        private static int elapsedYears(BadiCalendar badiCalendar) {
            return ((badiCalendar.major - 1) * 19 + (badiCalendar.cycle - 1)) * 19 + badiCalendar.year - 1;
        }

        private static int elapsedMonths(BadiCalendar badiCalendar) {
            int n = badiCalendar.isIntercalaryDay() ? 18 : badiCalendar.getMonth().getValue();
            return 19 * FUnitRule.elapsedYears(badiCalendar) + n - 1;
        }
    }

    private static class Merger
    implements ChronoMerger<BadiCalendar> {
        private Merger() {
        }

        @Override
        public BadiCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (BadiCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, tZID, startOfDay).toDate();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public BadiCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            BadiCalendar badiCalendar;
            int n = chronoEntity.getInt(KULL_I_SHAI);
            if (n == Integer.MIN_VALUE) {
                n = 1;
            } else if (n < 1 || n > 3) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Major cycle out of range: " + n);
                return null;
            }
            int n2 = chronoEntity.getInt(VAHID);
            boolean bl3 = true;
            if (n2 == Integer.MIN_VALUE) {
                bl3 = false;
            } else if (n2 < 1 || n2 > 19) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Vahid cycle out of range: " + n2);
                return null;
            }
            int n3 = chronoEntity.getInt(YEAR_OF_VAHID);
            if (n3 == Integer.MIN_VALUE) {
                if (!chronoEntity.contains(YEAR_OF_ERA)) {
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing year-of-vahid.");
                    return null;
                }
                badiCalendar = (BadiCalendar)((BadiCalendar)BadiCalendar.axis().getMinimum()).with((ChronoElement<Integer>)YEAR_OF_ERA, chronoEntity.getInt(YEAR_OF_ERA));
                n = badiCalendar.getKullishai();
                n2 = badiCalendar.getVahid();
                n3 = badiCalendar.getYearOfVahid();
            } else {
                if (!bl3) {
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing vahid cycle.");
                    return null;
                }
                if (n3 < 1 || n3 > 19) {
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Badi year-of-vahid out of range: " + n3);
                    return null;
                }
            }
            badiCalendar = null;
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n4 = ((BadiMonth)chronoEntity.get(MONTH_OF_YEAR)).getValue();
                int n5 = chronoEntity.getInt(DAY_OF_DIVISION);
                if (n5 >= 1 && n5 <= 19) {
                    return new BadiCalendar(n, n2, n3, n4, n5);
                }
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Badi date.");
                return badiCalendar;
            }
            if (chronoEntity.contains(AYYAM_I_HA)) {
                int n6 = chronoEntity.getInt(DAY_OF_DIVISION);
                if (n6 >= 1 && n6 <= (BadiCalendar.isLeapYear(n, n2, n3) ? 5 : 4)) {
                    return new BadiCalendar(n, n2, n3, 0, n6);
                }
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Badi date.");
                return badiCalendar;
            }
            int n7 = chronoEntity.getInt(DAY_OF_YEAR);
            boolean bl4 = BadiCalendar.isLeapYear(n, n2, n3);
            if (n7 == Integer.MIN_VALUE) return badiCalendar;
            if (n7 >= 1 && n7 <= (bl4 ? 366 : 365)) {
                int n8;
                int n9;
                if (n7 <= 342) {
                    n9 = (n7 - 1) / 19 + 1;
                    n8 = (n7 - 1) % 19 + 1;
                    return new BadiCalendar(n, n2, n3, n9, n8);
                } else if (n7 <= 342 + (bl4 ? 5 : 4)) {
                    n9 = 0;
                    n8 = n7 - 342;
                    return new BadiCalendar(n, n2, n3, n9, n8);
                } else {
                    n9 = 19;
                    n8 = n7 - (bl4 ? 5 : 4) - 342;
                }
                return new BadiCalendar(n, n2, n3, n9, n8);
            }
            chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Badi date.");
            return badiCalendar;
        }

        @Override
        public int getDefaultPivotYear() {
            return PlainDate.axis().getDefaultPivotYear() - 1844;
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.definedBy(TEHERAN.sunset());
        }
    }

    private static class WeekdayRule
    implements ElementRule<BadiCalendar, Weekday> {
        private WeekdayRule() {
        }

        @Override
        public Weekday getValue(BadiCalendar badiCalendar) {
            return badiCalendar.getDayOfWeek();
        }

        @Override
        public Weekday getMinimum(BadiCalendar badiCalendar) {
            if (badiCalendar.major == 1 && badiCalendar.cycle == 1 && badiCalendar.year == 1 && badiCalendar.division == 1 && badiCalendar.day <= 2) {
                return Weekday.THURSDAY;
            }
            return Weekday.SATURDAY;
        }

        @Override
        public Weekday getMaximum(BadiCalendar badiCalendar) {
            if (badiCalendar.major == 3 && badiCalendar.cycle == 19 && badiCalendar.year == 19 && badiCalendar.division == 19 && badiCalendar.day >= 14) {
                return Weekday.THURSDAY;
            }
            return Weekday.FRIDAY;
        }

        @Override
        public boolean isValid(BadiCalendar badiCalendar, Weekday weekday) {
            if (weekday == null) {
                return false;
            }
            Weekmodel weekmodel = BadiCalendar.getDefaultWeekmodel();
            int n = weekday.getValue(weekmodel);
            int n2 = this.getMinimum(badiCalendar).getValue(weekmodel);
            int n3 = this.getMaximum(badiCalendar).getValue(weekmodel);
            return n2 <= n && n <= n3;
        }

        @Override
        public BadiCalendar withValue(BadiCalendar badiCalendar, Weekday weekday, boolean bl) {
            if (weekday == null) {
                throw new IllegalArgumentException("Missing weekday.");
            }
            Weekmodel weekmodel = BadiCalendar.getDefaultWeekmodel();
            int n = badiCalendar.getDayOfWeek().getValue(weekmodel);
            int n2 = weekday.getValue(weekmodel);
            return (BadiCalendar)badiCalendar.plus(CalendarDays.of(n2 - n));
        }

        @Override
        public ChronoElement<?> getChildAtFloor(BadiCalendar badiCalendar) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(BadiCalendar badiCalendar) {
            return null;
        }
    }

    private static class IntercalaryAccess
    extends BasicElement<BadiIntercalaryDays>
    implements TextElement<BadiIntercalaryDays>,
    ElementRule<BadiCalendar, BadiIntercalaryDays> {
        static final IntercalaryAccess SINGLETON = new IntercalaryAccess();
        private static final long serialVersionUID = -772152174221291354L;

        private IntercalaryAccess() {
            super("AYYAM_I_HA");
        }

        @Override
        public char getSymbol() {
            return 'A';
        }

        @Override
        public BadiIntercalaryDays getValue(BadiCalendar badiCalendar) {
            if (badiCalendar.isIntercalaryDay()) {
                return BadiIntercalaryDays.AYYAM_I_HA;
            }
            throw new ChronoException("The actual calendar date is not an intercalary day: " + badiCalendar);
        }

        @Override
        public BadiIntercalaryDays getMinimum(BadiCalendar badiCalendar) {
            return BadiIntercalaryDays.AYYAM_I_HA;
        }

        @Override
        public BadiIntercalaryDays getMaximum(BadiCalendar badiCalendar) {
            return BadiIntercalaryDays.AYYAM_I_HA;
        }

        @Override
        public boolean isValid(BadiCalendar badiCalendar, BadiIntercalaryDays badiIntercalaryDays) {
            return badiIntercalaryDays == BadiIntercalaryDays.AYYAM_I_HA;
        }

        @Override
        public BadiCalendar withValue(BadiCalendar badiCalendar, BadiIntercalaryDays badiIntercalaryDays, boolean bl) {
            if (badiIntercalaryDays != BadiIntercalaryDays.AYYAM_I_HA) {
                throw new IllegalArgumentException("Expected Ayyam-i-Ha: " + badiIntercalaryDays);
            }
            int n = Math.min(badiCalendar.day, badiCalendar.isLeapYear() ? 5 : 4);
            return new BadiCalendar(badiCalendar.major, badiCalendar.cycle, badiCalendar.year, 0, n);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(BadiCalendar badiCalendar) {
            return DAY_OF_DIVISION;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(BadiCalendar badiCalendar) {
            return DAY_OF_DIVISION;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            BadiIntercalaryDays badiIntercalaryDays = chronoDisplay.get(this);
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            appendable.append(this.accessor(locale, attributeQuery).print(badiIntercalaryDays));
        }

        @Override
        public BadiIntercalaryDays parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            return this.accessor(locale, attributeQuery).parse(charSequence, parsePosition, this.getType(), attributeQuery);
        }

        @Override
        public Class<BadiIntercalaryDays> getType() {
            return BadiIntercalaryDays.class;
        }

        @Override
        public BadiIntercalaryDays getDefaultMinimum() {
            return BadiIntercalaryDays.AYYAM_I_HA;
        }

        @Override
        public BadiIntercalaryDays getDefaultMaximum() {
            return BadiIntercalaryDays.AYYAM_I_HA;
        }

        @Override
        public String getDisplayName(Locale locale) {
            return BadiIntercalaryDays.AYYAM_I_HA.getDisplayName(locale);
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        private TextAccessor accessor(Locale locale, AttributeQuery attributeQuery) {
            FormattedContent formattedContent = attributeQuery.get(TEXT_CONTENT_ATTRIBUTE, FormattedContent.TRANSCRIPTION);
            CalendarText calendarText = CalendarText.getInstance("bahai", locale);
            String string = "A";
            if (formattedContent == FormattedContent.MEANING && calendarText.getTextForms().containsKey("a")) {
                string = "a";
            }
            return calendarText.getTextForms(string, this.getType(), new String[0]);
        }
    }

    private static class YOV
    extends DisplayElement<Integer>
    implements TextElement<Integer> {
        static final YOV SINGLETON = new YOV();
        private static final long serialVersionUID = -8280579801733395557L;

        private YOV() {
            super("YEAR_OF_VAHID");
        }

        @Override
        public char getSymbol() {
            return 'X';
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            int n = chronoDisplay.getInt(this);
            BadiMonth badiMonth = YOV.enumAccess().getEnumConstants()[n - 1];
            appendable.append(this.accessor(attributeQuery).print(badiMonth));
        }

        @Override
        public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            BadiMonth badiMonth = this.accessor(attributeQuery).parse(charSequence, parsePosition, YOV.enumAccess(), attributeQuery);
            if (badiMonth == null) {
                return null;
            }
            return badiMonth.ordinal() + 1;
        }

        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public Integer getDefaultMinimum() {
            return 1;
        }

        @Override
        public Integer getDefaultMaximum() {
            return 19;
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        private TextAccessor accessor(AttributeQuery attributeQuery) {
            Locale locale = BadiCalendar.getLocale(attributeQuery);
            FormattedContent formattedContent = BadiCalendar.getFormattedContent(attributeQuery);
            CalendarText calendarText = CalendarText.getInstance("bahai", locale);
            return calendarText.getTextForms("YOV", YOV.enumAccess(), formattedContent.variant());
        }

        private static Class<BadiMonth> enumAccess() {
            return BadiMonth.class;
        }
    }

    private static class DowElement
    extends StdWeekdayElement<BadiCalendar> {
        static final DowElement SINGLETON = new DowElement();
        private static final long serialVersionUID = -1733732651700208755L;

        private DowElement() {
            super(BadiCalendar.class, BadiCalendar.getDefaultWeekmodel());
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
            Weekday weekday = chronoDisplay.get(this).roll(2);
            appendable.append(this.accessor(attributeQuery).print(weekday));
        }

        @Override
        public Weekday parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            return this.accessor(attributeQuery).parse(charSequence, parsePosition, Weekday.class, attributeQuery).roll(-2);
        }

        private TextAccessor accessor(AttributeQuery attributeQuery) {
            Locale locale = BadiCalendar.getLocale(attributeQuery);
            FormattedContent formattedContent = BadiCalendar.getFormattedContent(attributeQuery);
            CalendarText calendarText = CalendarText.getInstance("bahai", locale);
            return calendarText.getTextForms("D", Weekday.class, formattedContent.variant());
        }
    }

    private static class MonthElement
    extends StdEnumDateElement<BadiMonth, BadiCalendar> {
        static final MonthElement SINGLETON = new MonthElement();
        private static final long serialVersionUID = -5483090643555757806L;

        private MonthElement() {
            super("MONTH_OF_YEAR", BadiCalendar.class, BadiMonth.class, 'M');
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
            BadiMonth badiMonth = chronoDisplay.get(this);
            appendable.append(this.accessor(attributeQuery).print(badiMonth));
        }

        @Override
        public BadiMonth parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            return this.accessor(attributeQuery).parse(charSequence, parsePosition, BadiMonth.class, attributeQuery);
        }

        private TextAccessor accessor(AttributeQuery attributeQuery) {
            Locale locale = BadiCalendar.getLocale(attributeQuery);
            FormattedContent formattedContent = BadiCalendar.getFormattedContent(attributeQuery);
            CalendarText calendarText = CalendarText.getInstance("bahai", locale);
            return calendarText.getTextForms("M", BadiMonth.class, formattedContent.variant());
        }
    }

    private static class MonthRule
    implements ElementRule<BadiCalendar, BadiMonth> {
        private MonthRule() {
        }

        @Override
        public BadiMonth getValue(BadiCalendar badiCalendar) {
            return badiCalendar.getMonth();
        }

        @Override
        public BadiMonth getMinimum(BadiCalendar badiCalendar) {
            return BadiMonth.BAHA;
        }

        @Override
        public BadiMonth getMaximum(BadiCalendar badiCalendar) {
            return BadiMonth.ALA;
        }

        @Override
        public boolean isValid(BadiCalendar badiCalendar, BadiMonth badiMonth) {
            return badiMonth != null;
        }

        @Override
        public BadiCalendar withValue(BadiCalendar badiCalendar, BadiMonth badiMonth, boolean bl) {
            if (badiMonth == null) {
                throw new IllegalArgumentException("Missing Badi month.");
            }
            int n = badiCalendar.isIntercalaryDay() ? 19 : badiCalendar.day;
            return new BadiCalendar(badiCalendar.major, badiCalendar.cycle, badiCalendar.year, badiMonth.getValue(), n);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(BadiCalendar badiCalendar) {
            return DAY_OF_DIVISION;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(BadiCalendar badiCalendar) {
            return DAY_OF_DIVISION;
        }
    }

    private static class IntegerRule
    implements IntElementRule<BadiCalendar> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        @Override
        public int getInt(BadiCalendar badiCalendar) {
            switch (this.index) {
                case 0: {
                    return badiCalendar.major;
                }
                case 1: {
                    return badiCalendar.cycle;
                }
                case 2: {
                    return badiCalendar.year;
                }
                case 3: {
                    return badiCalendar.day;
                }
                case 4: {
                    return badiCalendar.getDayOfYear();
                }
                case 5: {
                    return badiCalendar.getYearOfEra();
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(BadiCalendar badiCalendar, int n) {
            int n2 = this.getMax(badiCalendar);
            return 1 <= n && n2 >= n;
        }

        @Override
        public BadiCalendar withValue(BadiCalendar badiCalendar, int n, boolean bl) {
            if (!this.isValid(badiCalendar, n)) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            int n2 = badiCalendar.day;
            switch (this.index) {
                case 0: {
                    if (n2 == 5 && badiCalendar.isIntercalaryDay() && !BadiCalendar.isLeapYear(n, badiCalendar.cycle, badiCalendar.year)) {
                        n2 = 4;
                    }
                    return new BadiCalendar(n, badiCalendar.cycle, badiCalendar.year, badiCalendar.division, n2);
                }
                case 1: {
                    if (n2 == 5 && badiCalendar.isIntercalaryDay() && !BadiCalendar.isLeapYear(badiCalendar.major, n, badiCalendar.year)) {
                        n2 = 4;
                    }
                    return new BadiCalendar(badiCalendar.major, n, badiCalendar.year, badiCalendar.division, n2);
                }
                case 2: {
                    if (n2 == 5 && badiCalendar.isIntercalaryDay() && !BadiCalendar.isLeapYear(badiCalendar.major, badiCalendar.cycle, n)) {
                        n2 = 4;
                    }
                    return new BadiCalendar(badiCalendar.major, badiCalendar.cycle, n, badiCalendar.division, n2);
                }
                case 3: {
                    return new BadiCalendar(badiCalendar.major, badiCalendar.cycle, badiCalendar.year, badiCalendar.division, n);
                }
                case 4: {
                    return badiCalendar.withDayOfYear(n);
                }
                case 5: {
                    int n3 = MathUtils.floorDivide(n - 1, 361) + 1;
                    int n4 = MathUtils.floorDivide(n - (n3 - 1) * 361 - 1, 19) + 1;
                    int n5 = MathUtils.floorModulo(n - 1, 19) + 1;
                    if (n2 == 5 && badiCalendar.isIntercalaryDay() && !BadiCalendar.isLeapYear(n3, n4, n5)) {
                        n2 = 4;
                    }
                    return BadiCalendar.ofComplete(n3, n4, n5, badiCalendar.getDivision(), n2);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getValue(BadiCalendar badiCalendar) {
            return this.getInt(badiCalendar);
        }

        @Override
        public Integer getMinimum(BadiCalendar badiCalendar) {
            return 1;
        }

        @Override
        public Integer getMaximum(BadiCalendar badiCalendar) {
            return this.getMax(badiCalendar);
        }

        @Override
        public boolean isValid(BadiCalendar badiCalendar, Integer n) {
            return n != null && this.isValid(badiCalendar, (int)n);
        }

        @Override
        public BadiCalendar withValue(BadiCalendar badiCalendar, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing new value.");
            }
            return this.withValue(badiCalendar, (int)n, bl);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(BadiCalendar badiCalendar) {
            switch (this.index) {
                case 0: {
                    return VAHID;
                }
                case 1: {
                    return YEAR_OF_VAHID;
                }
                case 2: 
                case 5: {
                    return MONTH_OF_YEAR;
                }
                case 3: 
                case 4: {
                    return null;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(BadiCalendar badiCalendar) {
            switch (this.index) {
                case 0: {
                    return VAHID;
                }
                case 1: {
                    return YEAR_OF_VAHID;
                }
                case 2: 
                case 5: {
                    return MONTH_OF_YEAR;
                }
                case 3: 
                case 4: {
                    return null;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        private int getMax(BadiCalendar badiCalendar) {
            switch (this.index) {
                case 0: {
                    return 3;
                }
                case 1: 
                case 2: {
                    return 19;
                }
                case 3: {
                    if (badiCalendar.isIntercalaryDay()) {
                        return badiCalendar.isLeapYear() ? 5 : 4;
                    }
                    return 19;
                }
                case 4: {
                    return badiCalendar.isLeapYear() ? 366 : 365;
                }
                case 5: {
                    return 1083;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }
    }

    private static class EraRule
    implements ElementRule<BadiCalendar, BadiEra> {
        private EraRule() {
        }

        @Override
        public BadiEra getValue(BadiCalendar badiCalendar) {
            return BadiEra.BAHAI;
        }

        @Override
        public BadiEra getMinimum(BadiCalendar badiCalendar) {
            return BadiEra.BAHAI;
        }

        @Override
        public BadiEra getMaximum(BadiCalendar badiCalendar) {
            return BadiEra.BAHAI;
        }

        @Override
        public boolean isValid(BadiCalendar badiCalendar, BadiEra badiEra) {
            return badiEra != null;
        }

        @Override
        public BadiCalendar withValue(BadiCalendar badiCalendar, BadiEra badiEra, boolean bl) {
            if (badiEra == null) {
                throw new IllegalArgumentException("Missing era value.");
            }
            return badiCalendar;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(BadiCalendar badiCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(BadiCalendar badiCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class Transformer
    implements CalendarSystem<BadiCalendar> {
        private static final long EPOCH = PlainDate.of(1844, 3, 21).getDaysSinceEpochUTC();

        private Transformer() {
        }

        @Override
        public BadiCalendar transform(long l) {
            if (l < EPOCH) {
                throw new IllegalArgumentException("Not defined before Bahai era: " + l);
            }
            if (l < (long)NEWROZ[0]) {
                PlainDate plainDate = PlainDate.of(l, EpochDays.UTC);
                int n = plainDate.getYear() - 1843;
                int n2 = plainDate.getMonth();
                if (n2 <= 2 || n2 == 3 && plainDate.getDayOfMonth() < 21) {
                    --n;
                }
                int n3 = MathUtils.floorModulo(n - 1, 19) + 1;
                int n4 = MathUtils.floorDivide(n - 1, 19) + 1;
                BadiCalendar badiCalendar = new BadiCalendar(1, n4, n3, 1, 1);
                return badiCalendar.withDayOfYear(MathUtils.safeCast(l - this.transform(badiCalendar) + 1L));
            }
            int n = NEWROZ.length - 2;
            for (int i = 0; i <= n; ++i) {
                if (l >= (long)NEWROZ[i + 1]) continue;
                int n5 = MathUtils.safeCast(l - (long)NEWROZ[i] + 1L);
                int n6 = i + 2015 - 1843;
                int n7 = MathUtils.floorDivide(n6 - 1, 361) + 1;
                int n8 = MathUtils.floorDivide(n6 - (n7 - 1) * 361 - 1, 19) + 1;
                int n9 = MathUtils.floorModulo(n6 - 1, 19) + 1;
                BadiCalendar badiCalendar = new BadiCalendar(n7, n8, n9, 1, 1);
                return badiCalendar.withDayOfYear(n5);
            }
            throw new IllegalArgumentException("Out of range: " + l);
        }

        @Override
        public long transform(BadiCalendar badiCalendar) {
            int n = badiCalendar.getRelatedGregorianYear();
            int n2 = badiCalendar.getDayOfYear();
            if (n < 2015) {
                return PlainDate.of(n, 3, 21).getDaysSinceEpochUTC() + (long)n2 - 1L;
            }
            return NEWROZ[n - 2015] + n2 - 1;
        }

        @Override
        public long getMinimumSinceUTC() {
            return EPOCH;
        }

        @Override
        public long getMaximumSinceUTC() {
            return NEWROZ[NEWROZ.length - 1] - 1;
        }

        @Override
        public List<CalendarEra> getEras() {
            return Collections.singletonList(BadiEra.BAHAI);
        }
    }

    public static enum Unit implements ChronoUnit
    {
        VAHID_CYCLES(5.9958192384E8),
        YEARS(3.155694336E7),
        MONTHS(1641600.0),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        public long between(BadiCalendar badiCalendar, BadiCalendar badiCalendar2) {
            return badiCalendar.until(badiCalendar2, this);
        }
    }
}

