/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import net.time4j.engine.ChronoElement;

public final class ElementPosition {
    private final ChronoElement<?> element;
    private final int startIndex;
    private final int endIndex;

    public ElementPosition(ChronoElement<?> chronoElement, int n, int n2) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative start index: " + n + " (" + chronoElement.name() + ")");
        }
        if (n2 <= n) {
            throw new IllegalArgumentException("End index " + n2 + " must be greater than start index " + n + " (" + chronoElement.name() + ")");
        }
        this.element = chronoElement;
        this.startIndex = n;
        this.endIndex = n2;
    }

    public ChronoElement<?> getElement() {
        return this.element;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ElementPosition) {
            ElementPosition elementPosition = (ElementPosition)object;
            return this.element.equals(elementPosition.element) && this.startIndex == elementPosition.startIndex && this.endIndex == elementPosition.endIndex;
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode() + 37 * (this.startIndex | this.endIndex << 16);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(",start-index=");
        stringBuilder.append(this.startIndex);
        stringBuilder.append(",end-index=");
        stringBuilder.append(this.endIndex);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

