/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.tz.NameStyle;
import net.time4j.tz.NamedID;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;

final class PlatformTimezone
extends Timezone {
    private static final long serialVersionUID = -8432968264242113551L;
    private final TZID id;
    private final TimeZone tz;
    private final boolean strict;
    private final transient ZonalOffset fixedOffset;

    PlatformTimezone() {
        this.id = null;
        this.tz = null;
        this.strict = false;
        this.fixedOffset = null;
    }

    PlatformTimezone(TZID tZID) {
        this(tZID, TimeZone.getDefault(), false);
    }

    PlatformTimezone(TZID tZID, String string) {
        this(tZID, PlatformTimezone.findZone(string), false);
    }

    private PlatformTimezone(TZID tZID, TimeZone timeZone, boolean bl) {
        this.id = tZID;
        this.tz = (TimeZone)timeZone.clone();
        this.strict = bl;
        if (this.tz.useDaylightTime()) {
            this.fixedOffset = null;
        } else {
            String string = this.tz.getID();
            boolean bl2 = string.startsWith("GMT") || string.startsWith("Etc/") || string.equals("Greenwich") || string.equals("UCT") || string.equals("UTC") || string.equals("Universal") || string.equals("Zulu");
            this.fixedOffset = bl2 ? PlatformTimezone.fromOffsetMillis(this.tz.getOffset(System.currentTimeMillis())) : null;
        }
    }

    @Override
    public TZID getID() {
        if (this.id == null) {
            String string = TimeZone.getDefault().getID();
            return new NamedID(string);
        }
        return this.id;
    }

    @Override
    public ZonalOffset getOffset(UnixTime unixTime) {
        TimeZone timeZone;
        if (this.id == null) {
            timeZone = TimeZone.getDefault();
        } else {
            if (this.fixedOffset != null) {
                return this.fixedOffset;
            }
            timeZone = this.tz;
        }
        return PlatformTimezone.fromOffsetMillis(timeZone.getOffset(unixTime.getPosixTime() * 1000L));
    }

    @Override
    public ZonalOffset getRawOffset(UnixTime unixTime) {
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTimeInMillis(unixTime.getPosixTime() * 1000L);
        return PlatformTimezone.fromOffsetMillis(gregorianCalendar.get(15));
    }

    @Override
    public ZonalOffset getExtraOffset(UnixTime unixTime) {
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTimeInMillis(unixTime.getPosixTime() * 1000L);
        return PlatformTimezone.fromOffsetMillis(gregorianCalendar.get(16));
    }

    @Override
    public ZonalOffset getOffset(GregorianDate gregorianDate, WallTime wallTime) {
        int n;
        int n2;
        if (this.fixedOffset != null) {
            return this.fixedOffset;
        }
        int n3 = gregorianDate.getYear();
        int n4 = gregorianDate.getMonth();
        int n5 = gregorianDate.getDayOfMonth();
        if (wallTime.getHour() == 24) {
            long l = MathUtils.safeAdd(GregorianMath.toMJD(gregorianDate), 1L);
            long l2 = GregorianMath.toPackedDate(l);
            n3 = GregorianMath.readYear(l2);
            n4 = GregorianMath.readMonth(l2);
            n5 = GregorianMath.readDayOfMonth(l2);
        }
        if (n3 > 0) {
            n2 = 1;
            n = n3;
        } else {
            n2 = 0;
            n = 1 - n3;
        }
        int n6 = GregorianMath.getDayOfWeek(n3, n4, n5) + 1;
        if (n6 == 8) {
            n6 = 1;
        }
        int n7 = wallTime.getHour() == 24 ? 0 : (wallTime.getHour() * 3600 + wallTime.getMinute() * 60 + wallTime.getSecond()) * 1000 + wallTime.getNanosecond() / 1000000;
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        return PlatformTimezone.fromOffsetMillis(timeZone.getOffset(n2, n, n4 - 1, n5, n6, n7));
    }

    @Override
    public boolean isInvalid(GregorianDate gregorianDate, WallTime wallTime) {
        if (this.fixedOffset != null) {
            return false;
        }
        int n = gregorianDate.getYear();
        int n2 = gregorianDate.getMonth();
        int n3 = gregorianDate.getDayOfMonth();
        int n4 = wallTime.getHour();
        int n5 = wallTime.getMinute();
        int n6 = wallTime.getSecond();
        int n7 = wallTime.getNanosecond() / 1000000;
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(14, n7);
        gregorianCalendar.set(n, n2 - 1, n3, n4, n5, n6);
        return gregorianCalendar.get(1) != n || gregorianCalendar.get(2) + 1 != n2 || gregorianCalendar.get(5) != n3 || gregorianCalendar.get(11) != n4 || gregorianCalendar.get(12) != n5 || gregorianCalendar.get(13) != n6 || gregorianCalendar.get(14) != n7;
    }

    @Override
    public boolean isDaylightSaving(UnixTime unixTime) {
        if (this.fixedOffset != null) {
            return false;
        }
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        return timeZone.inDaylightTime(new Date(unixTime.getPosixTime() * 1000L));
    }

    @Override
    public boolean isFixed() {
        return this.fixedOffset != null;
    }

    @Override
    public TransitionHistory getHistory() {
        return this.fixedOffset == null ? null : this.fixedOffset.getModel();
    }

    public boolean equals(Object object) {
        if (object instanceof PlatformTimezone) {
            PlatformTimezone platformTimezone = (PlatformTimezone)object;
            if (this.id == null) {
                return platformTimezone.id == null;
            }
            if (!this.tz.equals(platformTimezone.tz) || this.strict != platformTimezone.strict) {
                return false;
            }
            if (this.fixedOffset == null) {
                return platformTimezone.fixedOffset == null;
            }
            return this.fixedOffset.equals(platformTimezone.fixedOffset);
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.tz.hashCode();
    }

    public String toString() {
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append('[');
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(':');
        stringBuilder.append(timeZone);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String getDisplayName(NameStyle nameStyle, Locale locale) {
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        return timeZone.getDisplayName(nameStyle.isDaylightSaving(), nameStyle.isAbbreviation() ? 0 : 1, locale);
    }

    @Override
    public TransitionStrategy getStrategy() {
        return this.strict ? STRICT_MODE : DEFAULT_CONFLICT_STRATEGY;
    }

    @Override
    public Timezone with(TransitionStrategy transitionStrategy) {
        if (this.id == null || this.getStrategy() == transitionStrategy) {
            return this;
        }
        if (transitionStrategy == DEFAULT_CONFLICT_STRATEGY) {
            return new PlatformTimezone(this.id, this.tz, false);
        }
        if (transitionStrategy == STRICT_MODE) {
            return new PlatformTimezone(this.id, this.tz, true);
        }
        throw new UnsupportedOperationException(transitionStrategy.toString());
    }

    static TimeZone findZone(String string) {
        if (string.equals("Z")) {
            return TimeZone.getTimeZone("GMT+00:00");
        }
        if (string.startsWith("UTC")) {
            return TimeZone.getTimeZone("GMT" + string.substring(3));
        }
        if (string.startsWith("UT")) {
            return TimeZone.getTimeZone("GMT" + string.substring(2));
        }
        return TimeZone.getTimeZone(string);
    }

    boolean isGMT() {
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        return timeZone.getID().equals("GMT");
    }

    private static ZonalOffset fromOffsetMillis(int n) {
        return ZonalOffset.ofTotalSeconds(MathUtils.floorDivide(n, 1000));
    }

    private Object readResolve() {
        if (this.id == null) {
            return new PlatformTimezone();
        }
        return new PlatformTimezone(this.id, this.tz, this.strict);
    }
}

