/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.authentication.handler;

import net.unicon.cas.addons.support.ThreadSafe;
import org.apache.shiro.crypto.hash.ConfigurableHashService;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashRequest;
import org.jasig.cas.authentication.handler.PasswordEncoder;

@ThreadSafe
public final class ShiroHashServicePasswordEncoder
implements PasswordEncoder {
    private final ConfigurableHashService hashService = new DefaultHashService();
    private String digestAlgorithmName;
    private String salt;
    private int hashIterations;

    public void setDigestAlgorithmName(String digestAlgorithmName) {
        this.digestAlgorithmName = digestAlgorithmName;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setHashIterations(int hashIterations) {
        this.hashIterations = hashIterations;
    }

    public String encode(String password) {
        if (password == null) {
            return null;
        }
        return this.hashService.computeHash(new HashRequest.Builder().setSalt((Object)this.salt).setSource((Object)password).build()).toHex();
    }

    void init() throws Throwable {
        if (this.digestAlgorithmName != null) {
            this.hashService.setHashAlgorithmName(this.digestAlgorithmName);
        }
        if (this.hashIterations > 0) {
            this.hashService.setHashIterations(this.hashIterations);
        }
    }
}

