/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.authentication.handler;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.UsernamePasswordRequest;
import com.stormpath.sdk.client.ApiKey;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.client.DefaultApiKey;
import com.stormpath.sdk.resource.ResourceException;
import net.unicon.cas.addons.support.Immutable;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.BadCredentialsAuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.springframework.beans.factory.BeanCreationException;

@Immutable
public class StormpathAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private final Application application;

    public StormpathAuthenticationHandler(String stormpathAccessId, String stormpathSecretKey, String applicationId) throws BeanCreationException {
        Client client = new Client((ApiKey)new DefaultApiKey(stormpathAccessId, stormpathSecretKey));
        try {
            this.application = (Application)client.getDataStore().getResource(String.format("/applications/%s", applicationId), Application.class);
        }
        catch (Throwable e) {
            throw new BeanCreationException("An exception is caught trying to access Stormpath cloud. Please verify that your provided Stormpath <accessId>, <secretKey>, and <applicationId> are correct. Original Stormpath error: " + e.getMessage());
        }
    }

    protected boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials credentials) throws AuthenticationException {
        try {
            this.log.debug("Attempting to authenticate user [{}] against application [{}] in Stormpath cloud...", (Object)credentials.getUsername(), (Object)this.application.getName());
            this.authenticateAccount(credentials);
            this.log.debug("Successfully authenticated user [{}]", (Object)credentials.getUsername());
            return true;
        }
        catch (ResourceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new BadCredentialsAuthenticationException();
        }
    }

    public Account authenticateAccount(UsernamePasswordCredentials credentials) throws ResourceException {
        return this.application.authenticateAccount((AuthenticationRequest)new UsernamePasswordRequest(credentials.getUsername(), credentials.getPassword())).getAccount();
    }
}

