/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.authentication.principal;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.group.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.unicon.cas.addons.support.Immutable;
import net.unicon.cas.addons.support.ThreadSafe;
import org.jasig.cas.authentication.principal.Principal;

@Immutable
@ThreadSafe
public class StormpathPrincipal
implements Principal {
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public StormpathPrincipal(Account account) {
        this.attributes.put("username", account.getUsername());
        this.attributes.put("email", account.getEmail());
        this.attributes.put("givenName", account.getGivenName());
        this.attributes.put("middleName", account.getMiddleName());
        this.attributes.put("surname", account.getSurname());
        this.attributes.put("status", account.getStatus().toString());
        ArrayList<String> groups = new ArrayList<String>();
        Iterator iter = account.getGroups().iterator();
        while (iter.hasNext()) {
            groups.add(((Group)iter.next()).getName());
        }
        this.attributes.put("groups", Collections.unmodifiableList(groups));
    }

    public String getId() {
        return (String)String.class.cast(this.attributes.get("username"));
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String toString() {
        return String.format("StormpathPrincipal{ attributes=%s }", this.attributes);
    }
}

