/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.authentication.principal;

import com.stormpath.sdk.account.Account;
import net.unicon.cas.addons.authentication.handler.StormpathAuthenticationHandler;
import net.unicon.cas.addons.authentication.principal.StormpathPrincipal;
import net.unicon.cas.addons.support.ThreadSafe;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StormpathPrincipalResolver
implements CredentialsToPrincipalResolver {
    private final StormpathAuthenticationHandler stormpathAuthenticationHandler;
    private static final Logger logger = LoggerFactory.getLogger(StormpathPrincipalResolver.class);

    public StormpathPrincipalResolver(StormpathAuthenticationHandler stormpathAuthenticationHandler) {
        this.stormpathAuthenticationHandler = stormpathAuthenticationHandler;
    }

    public Principal resolvePrincipal(Credentials credentials) {
        UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)UsernamePasswordCredentials.class.cast(credentials);
        try {
            Account account = this.stormpathAuthenticationHandler.authenticateAccount(usernamePasswordCredentials);
            StormpathPrincipal principal = new StormpathPrincipal(account);
            logger.debug("Successfully resolved {}", (Object)principal);
            return principal;
        }
        catch (Throwable e) {
            logger.error("An exception is caught trying to access Stormpath cloud while resolving StormpathPrincipal: {} ", (Object)e.getMessage());
            return null;
        }
    }

    public boolean supports(Credentials credentials) {
        return credentials != null && UsernamePasswordCredentials.class.isAssignableFrom(credentials.getClass());
    }
}

