/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.authentication.strong.oath.totp;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;
import net.unicon.cas.addons.authentication.strong.oath.totp.TOTP;
import org.apache.commons.codec.binary.Base32;

public class TOTPUtils {
    private static final int SECRET_SIZE = 10;
    private static final int PASS_CODE_LENGTH = 6;
    private static final String CRYPTO = "HmacSHA1";
    private static final Random rand = new Random();

    public static String generateSecret() {
        byte[] buffer = new byte[10];
        rand.nextBytes(buffer);
        Base32 codec = new Base32();
        byte[] secretKey = Arrays.copyOf(buffer, 10);
        byte[] encodedKey = codec.encode(secretKey);
        return new String(encodedKey);
    }

    public static boolean checkCode(String secret, long code, int interval, int window) throws NoSuchAlgorithmException, InvalidKeyException {
        Base32 codec = new Base32();
        byte[] decodedKey = codec.decode(secret);
        long currentInterval = TOTPUtils.getCurrentInterval(interval);
        int i = -window;
        while (i <= window) {
            long hash = TOTP.generateTOTP(decodedKey, currentInterval + (long)i, 6, CRYPTO);
            if (hash == code) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static long getCurrentInterval(int interval) {
        long currentTimeSeconds = System.currentTimeMillis() / 1000L;
        return currentTimeSeconds / (long)interval;
    }
}

