/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.authentication.strong.oath.totp;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import net.unicon.cas.addons.authentication.strong.oath.totp.TOTPUtils;
import net.unicon.cas.addons.authentication.strong.oath.totp.TotpOathDetailsSource;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotpAuthenticationHandler
implements AuthenticationHandler {
    private TotpOathDetailsSource totpOathDetailsSource;
    private static Logger logger = LoggerFactory.getLogger(TotpAuthenticationHandler.class);

    public TotpAuthenticationHandler(TotpOathDetailsSource totpOathDetailsSource) {
        this.totpOathDetailsSource = totpOathDetailsSource;
    }

    public boolean authenticate(Credentials credentials) throws AuthenticationException {
        UsernamePasswordCredentials totpCredentials = (UsernamePasswordCredentials)credentials;
        logger.info("Authenticating one time password for {}", (Object)totpCredentials);
        Map<TotpOathDetailsSource.OTP, Object> attrs = this.totpOathDetailsSource.getOtpAttributesForPrincipal(totpCredentials.getUsername());
        String seceretKey = (String)attrs.get((Object)TotpOathDetailsSource.OTP.SECRET_KEY);
        Integer interval = (Integer)attrs.get((Object)TotpOathDetailsSource.OTP.INTERVAL);
        Integer intervalWindow = (Integer)attrs.get((Object)TotpOathDetailsSource.OTP.INTERVAL_WINDOW);
        try {
            return TOTPUtils.checkCode(seceretKey, Long.valueOf(totpCredentials.getPassword()), interval, intervalWindow);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error(ex.getMessage());
            return false;
        }
        catch (InvalidKeyException ex) {
            logger.error(ex.getMessage());
            return false;
        }
    }

    public boolean supports(Credentials credentials) {
        return credentials != null && UsernamePasswordCredentials.class.equals(credentials.getClass());
    }
}

