/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.authentication.strong.yubikey;

import com.yubico.client.v2.YubicoClient;
import com.yubico.client.v2.YubicoResponse;
import com.yubico.client.v2.YubicoResponseStatus;
import net.unicon.cas.addons.authentication.strong.yubikey.YubiKeyAccountRegistry;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.BadUsernameOrPasswordAuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.springframework.beans.factory.InitializingBean;

public class YubiKeyAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler
implements InitializingBean {
    private YubiKeyAccountRegistry registry = new AcceptAnyYubiKeyAccountRegistry();
    private YubicoClient client;

    public YubiKeyAuthenticationHandler(Integer clientId, String secretKey) {
        this.client = YubicoClient.getClient((Integer)clientId);
        this.client.setKey(secretKey);
    }

    public YubiKeyAuthenticationHandler(Integer clientId, String secretKey, YubiKeyAccountRegistry registry) {
        this(clientId, secretKey);
        this.registry = registry;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.registry instanceof AcceptAnyYubiKeyAccountRegistry) {
            this.log.warn("{} instantiated with example accept-any configuration handled via {}. THIS IS NOT OKAY IN PRODUCTION. NO. NO. NO.", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)AcceptAnyYubiKeyAccountRegistry.class.getSimpleName());
        }
    }

    protected boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials usernamePasswordCredentials) throws AuthenticationException {
        try {
            String uid = usernamePasswordCredentials.getUsername();
            String otp = usernamePasswordCredentials.getPassword();
            if (YubicoClient.isValidOTPFormat((String)otp)) {
                String publicId = YubicoClient.getPublicId((String)otp);
                if (this.registry.isYubiKeyRegisteredFor(uid, publicId)) {
                    YubicoResponse response = this.client.verify(otp);
                    this.log.debug("YubiKey response status {} at {}", (Object)response.getStatus(), (Object)response.getTimestamp());
                    return response.getStatus() == YubicoResponseStatus.OK;
                }
                this.log.debug("YubiKey public id [{}] is not registered for user [{}]", (Object)publicId, (Object)uid);
            } else {
                this.log.debug("Invalid OTP format [{}]", (Object)otp);
            }
            return false;
        }
        catch (Exception e) {
            throw new BadUsernameOrPasswordAuthenticationException((Throwable)e);
        }
    }

    private static final class AcceptAnyYubiKeyAccountRegistry
    implements YubiKeyAccountRegistry {
        private AcceptAnyYubiKeyAccountRegistry() {
        }

        @Override
        public boolean isYubiKeyRegisteredFor(String uid, String yubikeyPublicId) {
            return true;
        }
    }
}

