/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.config;

import com.github.inspektr.audit.support.Slf4jLoggingAuditTrailManager;
import java.util.Arrays;
import java.util.List;
import net.unicon.cas.addons.authentication.handler.StormpathAuthenticationHandler;
import net.unicon.cas.addons.authentication.internal.DefaultAuthenticationSupport;
import net.unicon.cas.addons.authentication.principal.StormpathPrincipalResolver;
import net.unicon.cas.addons.authentication.strong.yubikey.YubiKeyAuthenticationHandler;
import net.unicon.cas.addons.info.events.CentralAuthenticationServiceEventsPublishingAspect;
import net.unicon.cas.addons.info.events.listeners.RedisStatsRecorderForServiceTicketValidatedEvents;
import net.unicon.cas.addons.info.events.listeners.RedisStatsRecorderForSsoSessionEstablishedEvents;
import net.unicon.cas.addons.persondir.JsonBackedComplexStubPersonAttributeDao;
import net.unicon.cas.addons.serviceregistry.JsonServiceRegistryDao;
import net.unicon.cas.addons.serviceregistry.ReadWriteJsonServiceRegistryDao;
import net.unicon.cas.addons.serviceregistry.RegisteredServicesReloadDisablingBeanFactoryPostProcessor;
import net.unicon.cas.addons.serviceregistry.services.authorization.DefaultRegisteredServiceAuthorizer;
import net.unicon.cas.addons.serviceregistry.services.authorization.ServiceAuthorizationAction;
import net.unicon.cas.addons.serviceregistry.services.internal.DefaultRegisteredServicesPolicies;
import net.unicon.cas.addons.support.ResourceChangeDetectingEventNotifier;
import net.unicon.cas.addons.support.TimingAspectRemovingBeanFactoryPostProcessor;
import net.unicon.cas.addons.ticket.registry.HazelcastTicketRegistry;
import net.unicon.cas.addons.web.flow.ServiceRedirectionAction;
import net.unicon.cas.addons.web.view.RequestParameterCasLoginViewSelector;
import org.jasig.cas.adaptors.generic.AcceptUsersAuthenticationHandler;
import org.jasig.cas.adaptors.ldap.BindLdapAuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationManagerImpl;
import org.jasig.cas.authentication.handler.support.HttpBasedServiceCredentialsAuthenticationHandler;
import org.jasig.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.HttpBasedServiceCredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentialsToPrincipalResolver;
import org.jasig.cas.monitor.HealthCheckMonitor;
import org.jasig.cas.monitor.MemoryMonitor;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CasNamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("inspektr-log-files-audit-manager", (BeanDefinitionParser)new InspektrSlf4jAuditTrailManagerBeanDefinitionParser());
        this.registerBeanDefinitionParser("json-services-registry", (BeanDefinitionParser)new JsonServicesRegistryDaoBeanDefinitionParser());
        this.registerBeanDefinitionParser("resource-change-detector", (BeanDefinitionParser)new ResourceChangeDetectingEventNotifierBeanDefinitionParser());
        this.registerBeanDefinitionParser("default-authentication-support", (BeanDefinitionParser)new DefaultAuthenticationSupportBeanDefinitionParser());
        this.registerBeanDefinitionParser("default-events-publisher", (BeanDefinitionParser)new DefaultEventsPublisherBeanDefinitionParser());
        this.registerBeanDefinitionParser("default-registered-services-policies", (BeanDefinitionParser)new DefaultRegisteredServicesPoliciesBeanDefinitionParser());
        this.registerBeanDefinitionParser("default-health-check-monitor", (BeanDefinitionParser)new DefaultHealthCheckMonitorBeanDefinitionParser());
        this.registerBeanDefinitionParser("default-test-authentication-manager", (BeanDefinitionParser)new DefaultTestAuthenticationManagerBeanDefinitionParser());
        this.registerBeanDefinitionParser("json-attribute-repository", (BeanDefinitionParser)new JsonAttributesRepositoryBeanDefinitionParser());
        this.registerBeanDefinitionParser("stormpath-authentication-handler", (BeanDefinitionParser)new StormpathAuthenticationHandlerBeanDefinitionParser());
        this.registerBeanDefinitionParser("authentication-manager-with-stormpath-handler", (BeanDefinitionParser)new AuthenticationManagerWithStormpathHandlerBeanDefinitionParser());
        this.registerBeanDefinitionParser("service-authorization-action", (BeanDefinitionParser)new ServiceAuthorizationActionBeanDefinitionParser());
        this.registerBeanDefinitionParser("disable-default-registered-services-reloading", (BeanDefinitionParser)new RegisteredServicesReloadDisablingBFPPBeanDefinitionParser());
        this.registerBeanDefinitionParser("yubikey-authentication-handler", (BeanDefinitionParser)new YubikeyAuthenticationHandlerBeanDefinitionParser());
        this.registerBeanDefinitionParser("accept-users-authentication-handler", (BeanDefinitionParser)new AcceptUsersAuthenticationHandlerBeanDefinitionParser());
        this.registerBeanDefinitionParser("bind-ldap-authentication-handler", (BeanDefinitionParser)new BindLdapAuthenticationHandlerBeanDefinitionParser());
        this.registerBeanDefinitionParser("authentication-manager-with-accept-users-handler", (BeanDefinitionParser)new AuthenticationManagerWithAcceptUsersHandlerBeanDefinitionParser());
        this.registerBeanDefinitionParser("authentication-manager-with-bind-ldap-handler", (BeanDefinitionParser)new AuthenticationManagerWithBindLdapHandlerBeanDefinitionParser());
        this.registerBeanDefinitionParser("disable-perf4j-timing-aspect", (BeanDefinitionParser)new TimingAspectRemovingBFPPBeanDefinitionParser());
        this.registerBeanDefinitionParser("events-redis-recorder", (BeanDefinitionParser)new EventsRedisRecorderBeanDefinitionParser());
        this.registerBeanDefinitionParser("hazelcast-ticket-registry", (BeanDefinitionParser)new HazelcastTicketRegistryBeanDefinitionParser());
        this.registerBeanDefinitionParser("service-redirection-action", (BeanDefinitionParser)new ServiceRedirectionActionBeanDefinitionParser());
        this.registerBeanDefinitionParser("request-param-login-view-selector", (BeanDefinitionParser)new RequestParameterLoginViewSelectorBeanDefinitionParser());
    }

    private static ManagedMap<String, String> buildUsersMap(Element element) {
        List userElements = DomUtils.getChildElementsByTagName((Element)element, (String)"user");
        ManagedMap usersMap = new ManagedMap(userElements.size());
        for (Element e : userElements) {
            usersMap.put((Object)e.getAttribute("name"), (Object)e.getAttribute("password"));
        }
        return usersMap;
    }

    private static void parseBindLdapAuthenticationHandlerBeanDefinition(Element element, BeanDefinitionBuilder contextSourceBuilder, BeanDefinitionBuilder bindLdapAuthnHandlerBuilder, BeanDefinitionRegistry beanDefinitionRegistry) {
        contextSourceBuilder.addPropertyValue("userDn", (Object)element.getAttribute("user-dn"));
        contextSourceBuilder.addPropertyValue("password", (Object)element.getAttribute("password"));
        contextSourceBuilder.addPropertyValue("urls", (Object)StringUtils.commaDelimitedListToSet((String)element.getAttribute("urls")));
        contextSourceBuilder.addPropertyValue("pooled", (Object)element.getAttribute("is-pooled"));
        Element ldapPropsElem = DomUtils.getChildElementByTagName((Element)element, (String)"ldap-properties");
        if (ldapPropsElem != null) {
            List propElements = DomUtils.getChildElementsByTagName((Element)element, (String)"ldap-prop");
            ManagedMap propsMap = new ManagedMap(propElements.size());
            for (Element e : propElements) {
                propsMap.put((Object)e.getAttribute("key"), (Object)e.getAttribute("value"));
            }
            contextSourceBuilder.addPropertyValue("baseEnvironmentProperties", (Object)propsMap);
        }
        bindLdapAuthnHandlerBuilder.addPropertyValue("filter", (Object)element.getAttribute("filter"));
        bindLdapAuthnHandlerBuilder.addPropertyValue("searchBase", (Object)element.getAttribute("search-base"));
        bindLdapAuthnHandlerBuilder.addPropertyValue("ignorePartialResultException", (Object)element.getAttribute("ignore-partial-result-exception"));
        bindLdapAuthnHandlerBuilder.addPropertyValue("contextSource", (Object)contextSourceBuilder.getBeanDefinition());
        String contextSourceBeanName = element.getAttribute("expose-context-source-bean-as");
        if (StringUtils.hasText((String)contextSourceBeanName)) {
            beanDefinitionRegistry.registerBeanDefinition(contextSourceBeanName, (BeanDefinition)contextSourceBuilder.getBeanDefinition());
        }
    }

    protected static abstract class AbstractDefaultAuthenticationManagerBeanDefinitionParser
    extends AbstractBeanDefinitionParser {
        protected AbstractDefaultAuthenticationManagerBeanDefinitionParser() {
        }

        protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
            AbstractBeanDefinition httpBasedPrincipalResolverBd = BeanDefinitionBuilder.genericBeanDefinition(HttpBasedServiceCredentialsToPrincipalResolver.class).getBeanDefinition();
            AbstractBeanDefinition httpBasedAuthnHandlerBd = BeanDefinitionBuilder.genericBeanDefinition(HttpBasedServiceCredentialsAuthenticationHandler.class).addPropertyReference("httpClient", "httpClient").getBeanDefinition();
            ManagedList principalResolversList = new ManagedList();
            principalResolversList.add((Object)httpBasedPrincipalResolverBd);
            AbstractBeanDefinition principalResolverBd = this.getCustomPrincipalResolver(element, parserContext);
            if (principalResolverBd == null) {
                BeanDefinitionBuilder b = BeanDefinitionBuilder.genericBeanDefinition(UsernamePasswordCredentialsToPrincipalResolver.class);
                String attrRepoBeanName = element.getAttribute("attribute-repository-for-principal-resolver");
                if (StringUtils.hasText((String)attrRepoBeanName)) {
                    b.addPropertyReference("attributeRepository", attrRepoBeanName);
                }
                principalResolverBd = b.getBeanDefinition();
            }
            principalResolversList.add((Object)principalResolverBd);
            ManagedList authnHandlersList = new ManagedList();
            authnHandlersList.addAll(Arrays.asList(httpBasedAuthnHandlerBd));
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AuthenticationManagerImpl.class).addPropertyValue("credentialsToPrincipalResolvers", (Object)principalResolversList).addPropertyValue("authenticationHandlers", (Object)authnHandlersList);
            String metadataPopulatorsRef = element.getAttribute("metadata-populators");
            if (StringUtils.hasText((String)metadataPopulatorsRef)) {
                builder.addPropertyReference("authenticationMetaDataPopulators", metadataPopulatorsRef);
            }
            return this.createAuthenticatonManagerBeanDefinition(element, parserContext, builder, authnHandlersList);
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return "authenticationManager";
        }

        protected AbstractBeanDefinition getCustomPrincipalResolver(Element element, ParserContext parserContext) {
            return null;
        }

        protected abstract AbstractBeanDefinition createAuthenticatonManagerBeanDefinition(Element var1, ParserContext var2, BeanDefinitionBuilder var3, ManagedList var4);
    }

    private static class AcceptUsersAuthenticationHandlerBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private AcceptUsersAuthenticationHandlerBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return AcceptUsersAuthenticationHandler.class;
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            builder.addPropertyValue("users", (Object)CasNamespaceHandler.buildUsersMap(element));
        }

        protected boolean shouldGenerateIdAsFallback() {
            return true;
        }
    }

    private static class AuthenticationManagerWithAcceptUsersHandlerBeanDefinitionParser
    extends AbstractDefaultAuthenticationManagerBeanDefinitionParser {
        private AuthenticationManagerWithAcceptUsersHandlerBeanDefinitionParser() {
        }

        @Override
        protected AbstractBeanDefinition createAuthenticatonManagerBeanDefinition(Element element, ParserContext parserContext, BeanDefinitionBuilder authenticationManagerBuilder, ManagedList authenticationHandlersList) {
            BeanDefinitionBuilder authnHandlerBuilder = BeanDefinitionBuilder.genericBeanDefinition(AcceptUsersAuthenticationHandler.class);
            authnHandlerBuilder.addPropertyValue("users", (Object)CasNamespaceHandler.buildUsersMap(element));
            authenticationHandlersList.add((Object)authnHandlerBuilder.getBeanDefinition());
            return authenticationManagerBuilder.getBeanDefinition();
        }
    }

    private static class AuthenticationManagerWithBindLdapHandlerBeanDefinitionParser
    extends AbstractDefaultAuthenticationManagerBeanDefinitionParser {
        private AuthenticationManagerWithBindLdapHandlerBeanDefinitionParser() {
        }

        @Override
        protected AbstractBeanDefinition createAuthenticatonManagerBeanDefinition(Element element, ParserContext parserContext, BeanDefinitionBuilder authenticationManagerBuilder, ManagedList authenticationHandlersList) {
            BeanDefinitionBuilder contextSourceBuilder = BeanDefinitionBuilder.genericBeanDefinition(LdapContextSource.class);
            BeanDefinitionBuilder bindLdapAuthnHandlerBuilder = BeanDefinitionBuilder.genericBeanDefinition(BindLdapAuthenticationHandler.class);
            CasNamespaceHandler.parseBindLdapAuthenticationHandlerBeanDefinition(element, contextSourceBuilder, bindLdapAuthnHandlerBuilder, parserContext.getRegistry());
            authenticationHandlersList.add((Object)bindLdapAuthnHandlerBuilder.getBeanDefinition());
            return authenticationManagerBuilder.getBeanDefinition();
        }
    }

    private static class AuthenticationManagerWithStormpathHandlerBeanDefinitionParser
    extends AbstractDefaultAuthenticationManagerBeanDefinitionParser {
        private AuthenticationManagerWithStormpathHandlerBeanDefinitionParser() {
        }

        @Override
        protected AbstractBeanDefinition createAuthenticatonManagerBeanDefinition(Element element, ParserContext parserContext, BeanDefinitionBuilder authenticationManagerBuilder, ManagedList authenticationHandlersList) {
            BeanDefinition authnHandler = parserContext.getRegistry().getBeanDefinition("stormpathAuthenticationHandler");
            authenticationHandlersList.add((Object)authnHandler);
            return authenticationManagerBuilder.getBeanDefinition();
        }

        @Override
        protected AbstractBeanDefinition getCustomPrincipalResolver(Element element, ParserContext parserContext) {
            AbstractBeanDefinition stormpathAuthnHandlerBd = BeanDefinitionBuilder.genericBeanDefinition(StormpathAuthenticationHandler.class).addConstructorArgValue((Object)element.getAttribute("access-id")).addConstructorArgValue((Object)element.getAttribute("secret-key")).addConstructorArgValue((Object)element.getAttribute("application-id")).getBeanDefinition();
            AbstractBeanDefinition stormpathPrincipalResolverBd = BeanDefinitionBuilder.genericBeanDefinition(StormpathPrincipalResolver.class).addConstructorArgValue((Object)stormpathAuthnHandlerBd).getBeanDefinition();
            parserContext.getRegistry().registerBeanDefinition("stormpathAuthenticationHandler", (BeanDefinition)stormpathAuthnHandlerBd);
            return stormpathPrincipalResolverBd;
        }
    }

    private static class BindLdapAuthenticationHandlerBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private BindLdapAuthenticationHandlerBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return BindLdapAuthenticationHandler.class;
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            BeanDefinitionBuilder contextSourceBuilder = BeanDefinitionBuilder.genericBeanDefinition(LdapContextSource.class);
            CasNamespaceHandler.parseBindLdapAuthenticationHandlerBeanDefinition(element, contextSourceBuilder, builder, parserContext.getRegistry());
        }

        protected boolean shouldGenerateIdAsFallback() {
            return true;
        }
    }

    private static class DefaultAuthenticationSupportBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private DefaultAuthenticationSupportBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return DefaultAuthenticationSupport.class;
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return "authenticationSupport";
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            builder.addConstructorArgReference("ticketRegistry");
        }
    }

    private static class DefaultEventsPublisherBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private DefaultEventsPublisherBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return CentralAuthenticationServiceEventsPublishingAspect.class;
        }

        protected boolean shouldGenerateId() {
            return true;
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            builder.addConstructorArgReference("authenticationSupport");
        }
    }

    private static class DefaultHealthCheckMonitorBeanDefinitionParser
    extends AbstractBeanDefinitionParser {
        private DefaultHealthCheckMonitorBeanDefinitionParser() {
        }

        protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
            AbstractBeanDefinition memoryMonitorBd = BeanDefinitionBuilder.genericBeanDefinition(MemoryMonitor.class).addPropertyValue("freeMemoryWarnThreshold", (Object)10).getBeanDefinition();
            ManagedList monitorsList = new ManagedList(1);
            monitorsList.add((Object)memoryMonitorBd);
            return BeanDefinitionBuilder.genericBeanDefinition(HealthCheckMonitor.class).addPropertyValue("monitors", (Object)monitorsList).getBeanDefinition();
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return "healthCheckMonitor";
        }
    }

    private static class DefaultRegisteredServicesPoliciesBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private DefaultRegisteredServicesPoliciesBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return DefaultRegisteredServicesPolicies.class;
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return "registeredServicesPolicies";
        }
    }

    private static class DefaultTestAuthenticationManagerBeanDefinitionParser
    extends AbstractDefaultAuthenticationManagerBeanDefinitionParser {
        private DefaultTestAuthenticationManagerBeanDefinitionParser() {
        }

        @Override
        protected AbstractBeanDefinition createAuthenticatonManagerBeanDefinition(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, ManagedList authenticationHandlersList) {
            authenticationHandlersList.add((Object)BeanDefinitionBuilder.genericBeanDefinition(SimpleTestUsernamePasswordAuthenticationHandler.class).getBeanDefinition());
            return builder.getBeanDefinition();
        }
    }

    private static class EventsRedisRecorderBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private EventsRedisRecorderBeanDefinitionParser() {
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return definition.getBeanClass().getName();
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            builder.addConstructorArgReference(element.getAttribute("redis-connection-factory"));
        }

        protected Class<?> getBeanClass(Element element) {
            return element.getAttribute("event-type").equals("sso-session-established") ? RedisStatsRecorderForSsoSessionEstablishedEvents.class : RedisStatsRecorderForServiceTicketValidatedEvents.class;
        }
    }

    private static class HazelcastTicketRegistryBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private HazelcastTicketRegistryBeanDefinitionParser() {
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            String idAttrValue = element.getAttribute("id");
            return StringUtils.hasText((String)idAttrValue) ? idAttrValue : "ticketRegistry";
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            builder.addConstructorArgReference(element.getAttribute("hazelcast-instance")).addConstructorArgValue((Object)element.getAttribute("tgt-entries-ttl-seconds")).addConstructorArgValue((Object)element.getAttribute("st-entries-ttl-seconds"));
        }

        protected Class<?> getBeanClass(Element element) {
            return HazelcastTicketRegistry.class;
        }
    }

    private static class InspektrSlf4jAuditTrailManagerBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private InspektrSlf4jAuditTrailManagerBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return Slf4jLoggingAuditTrailManager.class;
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return "auditTrailManager";
        }
    }

    private static class JsonAttributesRepositoryBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private JsonAttributesRepositoryBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return JsonBackedComplexStubPersonAttributeDao.class;
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            builder.addConstructorArgValue((Object)element.getAttribute("config-file"));
            builder.setInitMethodName("init");
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return "attributeRepository";
        }
    }

    private static class JsonServicesRegistryDaoBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private JsonServicesRegistryDaoBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return Boolean.valueOf(element.getAttribute("read-write")) != false ? ReadWriteJsonServiceRegistryDao.class : JsonServiceRegistryDao.class;
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            builder.addConstructorArgValue((Object)element.getAttribute("config-file"));
            builder.setInitMethodName("loadServices");
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return "serviceRegistryDao";
        }
    }

    private static class RegisteredServicesReloadDisablingBFPPBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private RegisteredServicesReloadDisablingBFPPBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return RegisteredServicesReloadDisablingBeanFactoryPostProcessor.class;
        }

        protected boolean shouldGenerateId() {
            return true;
        }
    }

    private static class RequestParameterLoginViewSelectorBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private RequestParameterLoginViewSelectorBeanDefinitionParser() {
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return "casLoginViewSelector";
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            String parameterNameVal = element.getAttribute("parameter-name");
            String defaultViewVal = element.getAttribute("default-view");
            if (StringUtils.hasText((String)parameterNameVal)) {
                builder.addPropertyValue("parameterName", (Object)parameterNameVal);
            }
            if (StringUtils.hasText((String)defaultViewVal)) {
                builder.addPropertyValue("defaultView", (Object)defaultViewVal);
            }
            builder.addPropertyValue("viewMappings", this.buildViewsMap(element));
        }

        protected Class<?> getBeanClass(Element element) {
            return RequestParameterCasLoginViewSelector.class;
        }

        private ManagedMap<String, String> buildViewsMap(Element element) {
            List loginViewElements = DomUtils.getChildElementsByTagName((Element)element, (String)"login-view");
            ManagedMap viewsMap = new ManagedMap(loginViewElements.size());
            for (Element e : loginViewElements) {
                viewsMap.put((Object)e.getAttribute("param"), (Object)e.getAttribute("view"));
            }
            return viewsMap;
        }
    }

    private static class ResourceChangeDetectingEventNotifierBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private ResourceChangeDetectingEventNotifierBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return ResourceChangeDetectingEventNotifier.class;
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            builder.addConstructorArgValue((Object)element.getAttribute("watched-resource"));
        }
    }

    private static class ServiceAuthorizationActionBeanDefinitionParser
    extends AbstractBeanDefinitionParser {
        private ServiceAuthorizationActionBeanDefinitionParser() {
        }

        protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
            String authorizerRef = element.getAttribute("authorizer");
            BeanDefinitionBuilder bdb = BeanDefinitionBuilder.genericBeanDefinition(ServiceAuthorizationAction.class).addConstructorArgReference("servicesManager").addConstructorArgReference("ticketRegistry");
            if (StringUtils.hasText((String)authorizerRef)) {
                bdb.addConstructorArgReference(authorizerRef);
            } else {
                bdb.addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(DefaultRegisteredServiceAuthorizer.class).getBeanDefinition());
            }
            return bdb.getBeanDefinition();
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return "serviceAuthorizationAction";
        }
    }

    private static class ServiceRedirectionActionBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private ServiceRedirectionActionBeanDefinitionParser() {
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return "serviceRedirectionCheck";
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            builder.addConstructorArgReference("servicesManager");
            String redirectionAdvisorRef = element.getAttribute("redirection-advisor");
            if (StringUtils.hasText((String)redirectionAdvisorRef)) {
                builder.addPropertyReference("redirectionAdvisor", redirectionAdvisorRef);
            }
        }

        protected Class<?> getBeanClass(Element element) {
            return ServiceRedirectionAction.class;
        }
    }

    private static class StormpathAuthenticationHandlerBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private StormpathAuthenticationHandlerBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return StormpathAuthenticationHandler.class;
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return "stormpathAuthenticationHandler";
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            builder.addConstructorArgValue((Object)element.getAttribute("access-id")).addConstructorArgValue((Object)element.getAttribute("secret-key")).addConstructorArgValue((Object)element.getAttribute("application-id"));
        }
    }

    private static class TimingAspectRemovingBFPPBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private TimingAspectRemovingBFPPBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return TimingAspectRemovingBeanFactoryPostProcessor.class;
        }

        protected boolean shouldGenerateId() {
            return true;
        }
    }

    private static class YubikeyAuthenticationHandlerBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private YubikeyAuthenticationHandlerBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return YubiKeyAuthenticationHandler.class;
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return "yubikeyAuthenticationHandler";
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            builder.addConstructorArgValue((Object)element.getAttribute("client-id")).addConstructorArgValue((Object)element.getAttribute("secret-key"));
            String accountRegistryRef = element.getAttribute("account-registry");
            if (StringUtils.hasText((String)accountRegistryRef)) {
                builder.addConstructorArgReference(accountRegistryRef);
            }
        }
    }
}

