/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.info;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.unicon.cas.addons.info.SingleSignOnSessionsReport;
import net.unicon.cas.addons.ticket.BulkRetrievalOfTicketsNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/")
public class SingleSignOnSessionsReportResource {
    private final SingleSignOnSessionsReport singleSignOnSessionsReport;
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private static final String ROOT_REPORT_ACTIVE_SESSIONS_KEY = "activeSsoSessions";
    private static final String ROOT_REPORT_NA_KEY = "notAvailable";
    private static final Logger logger = LoggerFactory.getLogger(SingleSignOnSessionsReportResource.class);

    @Autowired
    public SingleSignOnSessionsReportResource(SingleSignOnSessionsReport singleSignOnSessionsReport) {
        this.singleSignOnSessionsReport = singleSignOnSessionsReport;
        this.jsonMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.jsonMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    @GET
    @Produces(value={"application/json"})
    public Response showActiveSsoSessions() {
        HashMap<String, Object> sessionsMap = new HashMap<String, Object>(1);
        Collection<Map<String, Object>> activeSessions = null;
        String jsonRepresentation = null;
        try {
            activeSessions = this.singleSignOnSessionsReport.getActiveSsoSessions();
            sessionsMap.put(ROOT_REPORT_ACTIVE_SESSIONS_KEY, activeSessions);
        }
        catch (BulkRetrievalOfTicketsNotSupportedException e) {
            logger.warn(e.getMessage(), e.getCause());
            sessionsMap.put(ROOT_REPORT_NA_KEY, e.getMessage());
        }
        try {
            jsonRepresentation = this.jsonMapper.writeValueAsString(sessionsMap);
        }
        catch (JsonProcessingException e) {
            logger.error("An exception has been caught during an attempt to serialize <active sso sessions report>", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok((Object)jsonRepresentation).build();
    }
}

