/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.info.events;

import net.unicon.cas.addons.authentication.AuthenticationSupport;
import net.unicon.cas.addons.info.events.CasServiceTicketGrantedEvent;
import net.unicon.cas.addons.info.events.CasServiceTicketValidatedEvent;
import net.unicon.cas.addons.info.events.CasSsoSessionDestroyedEvent;
import net.unicon.cas.addons.info.events.CasSsoSessionEstablishedEvent;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

@Aspect
public class CentralAuthenticationServiceEventsPublishingAspect
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher eventPublisher;
    private final AuthenticationSupport authenticationSupport;
    private final Logger logger = LoggerFactory.getLogger(CentralAuthenticationServiceEventsPublishingAspect.class);

    public CentralAuthenticationServiceEventsPublishingAspect(AuthenticationSupport authenticationSupport) {
        this.authenticationSupport = authenticationSupport;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    @Pointcut(value="execution(public * org.jasig.cas.CentralAuthenticationService+.createTicketGrantingTicket(..))")
    private void createTicketGrantingTicketMethodExecution() {
    }

    @Pointcut(value="execution(public * org.jasig.cas.CentralAuthenticationService+.destroyTicketGrantingTicket(..))")
    private void destroyTicketGrantingTicketMethodExecution() {
    }

    @Pointcut(value="execution(public * org.jasig.cas.CentralAuthenticationService+.grantServiceTicket(String, org.jasig.cas.authentication.principal.Service))")
    private void grantServiceTicketMethodExecution() {
    }

    @Pointcut(value="execution(public * org.jasig.cas.CentralAuthenticationService+.validateServiceTicket(..))")
    private void validateServiceTicketMethodExecution() {
    }

    @AfterReturning(pointcut="createTicketGrantingTicketMethodExecution()", returning="ticketGrantingTicketId")
    public void publishCasSsoSessionEstablishedEvent(JoinPoint jp, String ticketGrantingTicketId) {
        this.doPublish(new CasSsoSessionEstablishedEvent(jp.getTarget(), this.authenticationSupport.getAuthenticationFrom(ticketGrantingTicketId), ticketGrantingTicketId));
    }

    @Around(value="destroyTicketGrantingTicketMethodExecution() && args(ticketGrantingTicketId)")
    public void publishCasSsoSessionDestroyedEvent(ProceedingJoinPoint jp, String ticketGrantingTicketId) throws Throwable {
        Authentication authToBeDestroyed = this.authenticationSupport.getAuthenticationFrom(ticketGrantingTicketId);
        CasSsoSessionDestroyedEvent e = new CasSsoSessionDestroyedEvent(jp.getTarget(), authToBeDestroyed, ticketGrantingTicketId);
        jp.proceed(new Object[]{ticketGrantingTicketId});
        this.doPublish(e);
    }

    @AfterReturning(pointcut="grantServiceTicketMethodExecution() && args(ticketGrantingTicketId, service)", returning="serviceTicketId")
    public void publishCasServiceTicketGrantedEvent(JoinPoint jp, String ticketGrantingTicketId, Service service, String serviceTicketId) {
        this.doPublish(new CasServiceTicketGrantedEvent(jp.getTarget(), serviceTicketId, service, this.authenticationSupport.getAuthenticationFrom(ticketGrantingTicketId)));
    }

    @AfterReturning(pointcut="validateServiceTicketMethodExecution() && args(serviceTicketId, service)", returning="assertion")
    public void publishCasServiceTicketValidatedEvent(JoinPoint jp, String serviceTicketId, Service service, Assertion assertion) {
        this.doPublish(new CasServiceTicketValidatedEvent(jp.getTarget(), serviceTicketId, service, assertion));
    }

    private void doPublish(ApplicationEvent e) {
        this.logger.info("Publishing {}", (Object)e);
        this.eventPublisher.publishEvent(e);
    }
}

