/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.info.events.listeners;

import net.unicon.cas.addons.info.events.CasServiceTicketValidatedEvent;
import net.unicon.cas.addons.support.ThreadSafe;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

@ThreadSafe
public class RedisStatsRecorderForServiceTicketValidatedEvents
implements ApplicationListener<CasServiceTicketValidatedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(RedisStatsRecorderForServiceTicketValidatedEvents.class);
    private StringRedisTemplate redisTemplate;

    public RedisStatsRecorderForServiceTicketValidatedEvents(JedisConnectionFactory connectionFactory) {
        this.redisTemplate = new StringRedisTemplate((RedisConnectionFactory)connectionFactory);
    }

    public void onApplicationEvent(CasServiceTicketValidatedEvent event) {
        String today = DateTime.now().toString("yyyy-MM-dd");
        try {
            logger.debug("Incrementing value for key 'cas:st-validated:{}' in Redis server...", (Object)today);
            this.redisTemplate.opsForValue().increment((Object)("cas:st-validated:" + today), 1L);
        }
        catch (Throwable e) {
            logger.warn("Unable to increment value for key 'cas:st-validated:'" + today + " in Redis. Caught the following exception: ", e);
        }
    }
}

