/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.info.events.listeners;

import net.unicon.cas.addons.info.events.CasSsoSessionEstablishedEvent;
import net.unicon.cas.addons.support.ThreadSafe;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

@ThreadSafe
public class RedisStatsRecorderForSsoSessionEstablishedEvents
implements ApplicationListener<CasSsoSessionEstablishedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(RedisStatsRecorderForSsoSessionEstablishedEvents.class);
    private StringRedisTemplate redisTemplate;

    public RedisStatsRecorderForSsoSessionEstablishedEvents(JedisConnectionFactory connectionFactory) {
        this.redisTemplate = new StringRedisTemplate((RedisConnectionFactory)connectionFactory);
    }

    public void onApplicationEvent(CasSsoSessionEstablishedEvent event) {
        String today = DateTime.now().toString("yyyy-MM-dd");
        try {
            logger.debug("Incrementing value for key 'cas:sso-sessions-established:{}' in Redis server...", (Object)today);
            this.redisTemplate.opsForValue().increment((Object)("cas:sso-sessions-established:" + today), 1L);
        }
        catch (Throwable e) {
            logger.warn("Unable to increment value for key 'cas:sso-sessions-established:'" + today + " in Redis. Caught the following exception: ", e);
        }
    }
}

