/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.info.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.unicon.cas.addons.info.SingleSignOnSessionsReport;
import net.unicon.cas.addons.support.ThreadSafe;
import net.unicon.cas.addons.ticket.BulkRetrievalOfTicketsNotSupportedException;
import net.unicon.cas.addons.ticket.TicketSupport;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ThreadSafe
@Component
public class DefaultSingleSignOnSessionsReport
implements SingleSignOnSessionsReport {
    private final TicketSupport ticketSupport;

    @Autowired
    public DefaultSingleSignOnSessionsReport(TicketSupport ticketSupport) {
        this.ticketSupport = ticketSupport;
    }

    @Override
    public Collection<Map<String, Object>> getActiveSsoSessions() throws BulkRetrievalOfTicketsNotSupportedException {
        ArrayList activeSessions = new ArrayList();
        for (TicketGrantingTicket tgt : this.ticketSupport.getNonExpiredTicketGrantingTickets()) {
            HashMap<String, Object> sso = new HashMap<String, Object>(3);
            sso.put(SingleSignOnSessionsReport.SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.toString(), tgt.getAuthentication().getPrincipal().getId());
            sso.put(SingleSignOnSessionsReport.SsoSessionAttributeKeys.AUTHENTICATION_DATE.toString(), tgt.getAuthentication().getAuthenticatedDate());
            sso.put(SingleSignOnSessionsReport.SsoSessionAttributeKeys.NUMBER_OF_USES.toString(), tgt.getCountOfUses());
            activeSessions.add(Collections.unmodifiableMap(sso));
        }
        return Collections.unmodifiableCollection(activeSessions);
    }
}

