/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.response.view.saml;

import java.lang.reflect.Field;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.xml.namespace.QName;
import org.jasig.cas.authentication.principal.SamlService;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.util.CasHTTPSOAP11Encoder;
import org.jasig.cas.web.support.SamlArgumentExtractor;
import org.jasig.cas.web.view.AbstractCasView;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.saml1.binding.encoding.HTTPSOAP11Encoder;
import org.opensaml.saml1.core.Response;
import org.opensaml.saml1.core.Status;
import org.opensaml.saml1.core.StatusCode;
import org.opensaml.saml1.core.StatusMessage;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.ConfigurationException;

public abstract class NoSamlNamespaceAbstractSaml10ResponseView
extends AbstractCasView {
    private static final String DEFAULT_ELEMENT_NAME_FIELD = "DEFAULT_ELEMENT_NAME";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private final SamlArgumentExtractor samlArgumentExtractor = new SamlArgumentExtractor();
    private final HTTPSOAP11Encoder encoder = new CasHTTPSOAP11Encoder();
    private final SecureRandomIdentifierGenerator idGenerator;
    @NotNull
    private String encoding = "UTF-8";

    static {
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException("Error initializing OpenSAML library.", e);
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected NoSamlNamespaceAbstractSaml10ResponseView() {
        try {
            this.idGenerator = new SecureRandomIdentifierGenerator();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Cannot create secure random ID generator for SAML message IDs.");
        }
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setCharacterEncoding(this.encoding);
        WebApplicationService service = this.samlArgumentExtractor.extractService(request);
        String serviceId = service != null ? service.getId() : "UNKNOWN";
        try {
            SamlService samlService;
            Response samlResponse = this.newSamlObject(Response.class);
            samlResponse.setID(this.generateId());
            samlResponse.setIssueInstant(new DateTime());
            samlResponse.setVersion(SAMLVersion.VERSION_11);
            samlResponse.setRecipient(serviceId);
            if (service instanceof SamlService && (samlService = (SamlService)service).getRequestID() != null) {
                samlResponse.setInResponseTo(samlService.getRequestID());
            }
            this.prepareResponse(samlResponse, model);
            BasicSAMLMessageContext messageContext = new BasicSAMLMessageContext();
            messageContext.setOutboundMessageTransport((OutTransport)new HttpServletResponseAdapter(response, request.isSecure()));
            messageContext.setOutboundSAMLMessage((SAMLObject)samlResponse);
            this.encoder.encode((MessageContext)messageContext);
        }
        catch (Exception e) {
            this.log.error("Error generating SAML response for service {}.", (Object)serviceId);
            throw e;
        }
    }

    protected abstract void prepareResponse(Response var1, Map<String, Object> var2);

    protected final String generateId() {
        return this.idGenerator.generateIdentifier();
    }

    protected final <T extends SAMLObject> T newSamlObject(Class<T> objectType) {
        QName qName;
        try {
            Field f = objectType.getField(DEFAULT_ELEMENT_NAME_FIELD);
            QName tempQName = (QName)f.get(null);
            qName = new QName(tempQName.getNamespaceURI(), tempQName.getLocalPart(), "");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException("Cannot find field " + objectType.getName() + "." + DEFAULT_ELEMENT_NAME_FIELD);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Cannot access field " + objectType.getName() + "." + DEFAULT_ELEMENT_NAME_FIELD);
        }
        SAMLObjectBuilder builder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(qName);
        if (builder == null) {
            throw new IllegalStateException("No SAMLObjectBuilder registered for class " + objectType.getName());
        }
        return (T)((SAMLObject)objectType.cast(builder.buildObject(qName)));
    }

    protected final Status newStatus(QName codeValue, String statusMessage) {
        Status status = this.newSamlObject(Status.class);
        StatusCode code = this.newSamlObject(StatusCode.class);
        code.setValue(codeValue);
        status.setStatusCode(code);
        if (statusMessage != null) {
            StatusMessage message = this.newSamlObject(StatusMessage.class);
            message.setMessage(statusMessage);
            status.setStatusMessage(message);
        }
        return status;
    }
}

