/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.serviceregistry;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.unicon.cas.addons.serviceregistry.RegexRegisteredServiceWithAttributes;
import net.unicon.cas.addons.serviceregistry.RegisteredServiceWithAttributesImpl;
import net.unicon.cas.addons.support.GuardedBy;
import net.unicon.cas.addons.support.ResourceChangeDetectingEventNotifier;
import net.unicon.cas.addons.support.ThreadSafe;
import org.jasig.cas.services.InMemoryServiceRegistryDaoImpl;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.ServiceRegistryDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@ThreadSafe
public class JsonServiceRegistryDao
implements ServiceRegistryDao,
ApplicationListener<ResourceChangeDetectingEventNotifier.ResourceChangedEvent> {
    @GuardedBy(value="mutexMonitor")
    private final InMemoryServiceRegistryDaoImpl delegateServiceRegistryDao = new InMemoryServiceRegistryDaoImpl();
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected final Resource servicesConfigFile;
    private ReloadableServicesManager servicesManager;
    private final Object mutexMonitor = new Object();
    private static final String REGEX_PREFIX = "^";
    protected static final String SERVICES_KEY = "services";
    private static final String SERVICES_ID_KEY = "serviceId";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public JsonServiceRegistryDao(Resource servicesConfigFile) {
        this.servicesConfigFile = servicesConfigFile;
    }

    public final void setServicesManager(ReloadableServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RegisteredService save(RegisteredService registeredService) {
        Object object = this.mutexMonitor;
        synchronized (object) {
            return this.saveInternal(registeredService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean delete(RegisteredService registeredService) {
        Object object = this.mutexMonitor;
        synchronized (object) {
            return this.deleteInternal(registeredService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RegisteredService findServiceById(long id) {
        Object object = this.mutexMonitor;
        synchronized (object) {
            return this.delegateServiceRegistryDao.findServiceById(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<RegisteredService> load() {
        Object object = this.mutexMonitor;
        synchronized (object) {
            return this.delegateServiceRegistryDao.load();
        }
    }

    protected RegisteredService saveInternal(RegisteredService registeredService) {
        return this.delegateServiceRegistryDao.save(registeredService);
    }

    protected boolean deleteInternal(RegisteredService registeredService) {
        return this.delegateServiceRegistryDao.delete(registeredService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<RegisteredService> loadServices() {
        ArrayList<RegisteredService> resolvedServices;
        block6: {
            this.logger.info("Loading Registered Services from: [ {} ]...", (Object)this.servicesConfigFile);
            resolvedServices = new ArrayList<RegisteredService>();
            try {
                Map<String, List> m = this.unmarshalServicesRegistryResourceIntoMap();
                if (m == null) break block6;
                for (Map record : m.get(SERVICES_KEY)) {
                    String svcId = (String)record.get(SERVICES_ID_KEY);
                    RegisteredService svc = this.getRegisteredServiceInstance(svcId);
                    if (svc == null) continue;
                    resolvedServices.add((RegisteredService)this.objectMapper.convertValue((Object)record, svc.getClass()));
                    this.logger.debug("Unmarshaled {}: {}", (Object)svc.getClass().getSimpleName(), (Object)record);
                }
                Object object = this.mutexMonitor;
                synchronized (object) {
                    this.delegateServiceRegistryDao.setRegisteredServices(resolvedServices);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return resolvedServices;
    }

    private Map<String, List> unmarshalServicesRegistryResourceIntoMap() throws IOException {
        try {
            InputStream stream = this.servicesConfigFile.getInputStream();
            if (stream != null) {
                return (Map)this.objectMapper.readValue(stream, Map.class);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.warn("Resource [{}] does not exist or has no service definitions.", (Object)this.servicesConfigFile);
        }
        return null;
    }

    private boolean isValidRegexPattern(String pattern) {
        boolean valid = false;
        try {
            if (pattern.startsWith(REGEX_PREFIX)) {
                Pattern.compile(pattern);
                valid = true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.logger.debug("Failed to identify [{}] as a regular expression", (Object)pattern);
        }
        return valid;
    }

    private RegisteredService getRegisteredServiceInstance(String pattern) {
        if (this.isValidRegexPattern(pattern)) {
            return new RegexRegisteredServiceWithAttributes();
        }
        return new RegisteredServiceWithAttributesImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onApplicationEvent(ResourceChangeDetectingEventNotifier.ResourceChangedEvent resourceChangedEvent) {
        try {
            if (!resourceChangedEvent.getResourceUri().equals(this.servicesConfigFile.getURI())) {
                return;
            }
        }
        catch (Throwable e) {
            this.logger.error("An exception is caught while trying to access JSON resource: ", e);
            return;
        }
        this.logger.debug("Received change event for JSON resource {}. Reloading services...", (Object)resourceChangedEvent.getResourceUri());
        Object object = this.mutexMonitor;
        synchronized (object) {
            this.loadServices();
            this.servicesManager.reload();
        }
    }

    @Component
    public static class ServicesManagerInjectableBeanPostProcessor
    implements BeanFactoryPostProcessor {
        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            JsonServiceRegistryDao serviceRegistryDao;
            ReloadableServicesManager servicesManager;
            try {
                servicesManager = (ReloadableServicesManager)beanFactory.getBean(ReloadableServicesManager.class);
                serviceRegistryDao = (JsonServiceRegistryDao)beanFactory.getBean(JsonServiceRegistryDao.class);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                return;
            }
            serviceRegistryDao.setServicesManager(servicesManager);
        }
    }
}

