/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.serviceregistry;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import net.unicon.cas.addons.serviceregistry.JsonServiceRegistryDao;
import org.apache.commons.io.IOUtils;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.RegisteredService;
import org.springframework.core.io.Resource;

public final class ReadWriteJsonServiceRegistryDao
extends JsonServiceRegistryDao {
    public ReadWriteJsonServiceRegistryDao(Resource servicesConfigFile) {
        super(servicesConfigFile);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    @Override
    protected RegisteredService saveInternal(RegisteredService registeredService) {
        this.logger.debug("Loading service definitions from resource [{}]", (Object)this.servicesConfigFile.getFilename());
        List<RegisteredService> resolvedServices = super.loadServices();
        ArrayList<RegisteredService> col = new ArrayList<RegisteredService>(resolvedServices);
        if (registeredService.getId() < 0L && registeredService instanceof AbstractRegisteredService) {
            Random random = new Random(registeredService.hashCode());
            int serviceId = random.nextInt(Integer.MAX_VALUE);
            ((AbstractRegisteredService)registeredService).setId((long)serviceId);
        }
        boolean foundAndRemovedService = false;
        Iterator it = col.iterator();
        while (!foundAndRemovedService && it.hasNext()) {
            if (((RegisteredService)it.next()).getId() != registeredService.getId()) continue;
            it.remove();
            foundAndRemovedService = true;
        }
        col.add(registeredService);
        this.saveListOfRegisteredServices(col);
        return registeredService;
    }

    @Override
    protected boolean deleteInternal(RegisteredService registeredService) {
        this.logger.debug("Loading service definitions from resource [{}]", (Object)this.servicesConfigFile.getFilename());
        List<RegisteredService> resolvedServices = super.loadServices();
        RegisteredService regServiceToDelete = this.findServiceById(registeredService.getId());
        if (regServiceToDelete != null) {
            this.logger.debug("Found service definition to remove: [{}]", (Object)regServiceToDelete);
            ArrayList<RegisteredService> col = new ArrayList<RegisteredService>(resolvedServices);
            col.remove(regServiceToDelete);
            this.saveListOfRegisteredServices(col);
            return true;
        }
        return false;
    }

    private void saveListOfRegisteredServices(List<RegisteredService> col) {
        block5: {
            BufferedOutputStream out = null;
            FileOutputStream fout = null;
            try {
                try {
                    fout = new FileOutputStream(this.servicesConfigFile.getFile());
                    out = new BufferedOutputStream(fout);
                    LinkedHashMap<String, List<RegisteredService>> map = new LinkedHashMap<String, List<RegisteredService>>(col.size());
                    map.put("services", col);
                    this.logger.debug("Writing [{}] service definitions to resource [{}]", (Object)col.size(), (Object)this.servicesConfigFile.getFilename());
                    this.objectMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)out, map);
                    fout.flush();
                    ((OutputStream)out).flush();
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    IOUtils.closeQuietly((OutputStream)fout);
                    IOUtils.closeQuietly((OutputStream)out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fout);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fout);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

