/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.serviceregistry.mongodb;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceRegistryDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public final class MongoServiceRegistryDao
implements ServiceRegistryDao,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MongoServiceRegistryDao.class);
    private static final String MONGODB_COLLECTION_NAME = RegisteredService.class.getSimpleName();
    private String collectionName = MONGODB_COLLECTION_NAME;
    private boolean dropCollection = false;
    @Autowired
    @NotNull
    private final MongoOperations mongoTemplate = null;

    public void afterPropertiesSet() throws Exception {
        if (this.dropCollection) {
            log.debug("Dropping database collection: {}", (Object)this.collectionName);
            this.mongoTemplate.dropCollection(this.collectionName);
        }
        if (!this.mongoTemplate.collectionExists(this.collectionName)) {
            log.debug("Creating database collection: {}", (Object)this.collectionName);
            this.mongoTemplate.createCollection(this.collectionName);
        }
    }

    @Transactional(readOnly=false)
    public boolean delete(RegisteredService svc) {
        if (this.findServiceById(svc.getId()) != null) {
            this.mongoTemplate.remove((Object)svc, this.collectionName);
            log.debug("Removed registered service: {}", (Object)svc);
            return true;
        }
        return false;
    }

    @Transactional(readOnly=true)
    public RegisteredService findServiceById(long svcId) {
        return (RegisteredService)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)svcId)), RegisteredService.class, this.collectionName);
    }

    @Transactional(readOnly=true)
    public List<RegisteredService> load() {
        return this.mongoTemplate.findAll(RegisteredService.class, this.collectionName);
    }

    @Transactional(readOnly=false)
    public RegisteredService save(RegisteredService svc) {
        if (svc.getId() == -1L) {
            ((AbstractRegisteredService)svc).setId((long)svc.hashCode());
        }
        this.mongoTemplate.save((Object)svc, this.collectionName);
        log.debug("Saved registered service: {}", (Object)svc);
        return this.findServiceById(svc.getId());
    }

    public void setCollectionName(String name) {
        this.collectionName = name;
    }

    public void setDropCollection(boolean dropCollection) {
        this.dropCollection = dropCollection;
    }
}

