/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.serviceregistry.services.authorization;

import java.util.Map;
import net.unicon.cas.addons.authentication.AuthenticationSupport;
import net.unicon.cas.addons.authentication.internal.DefaultAuthenticationSupport;
import net.unicon.cas.addons.serviceregistry.RegisteredServiceWithAttributes;
import net.unicon.cas.addons.serviceregistry.services.authorization.RegisteredServiceAuthorizer;
import net.unicon.cas.addons.serviceregistry.services.authorization.RoleBasedServiceAuthorizationException;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ServiceAuthorizationAction
extends AbstractAction {
    private final ServicesManager servicesManager;
    private final RegisteredServiceAuthorizer authorizer;
    private final AuthenticationSupport authenticationSupport;
    private static final String AUTHZ_ATTRS_KEY = "authzAttributes";
    private static final String AUTHZ_FAIL_REDIRECT_URL_KEY = "authorizationFailureRedirectUrl";
    private static final String ATTR_URL_KEY = "unauthorizedRedirectUrl";
    private static final Logger logger = LoggerFactory.getLogger(ServiceAuthorizationAction.class);

    public ServiceAuthorizationAction(ServicesManager servicesManager, TicketRegistry ticketRegistry, RegisteredServiceAuthorizer registeredServiceAuthorizer) {
        this.servicesManager = servicesManager;
        this.authorizer = registeredServiceAuthorizer;
        this.authenticationSupport = new DefaultAuthenticationSupport(ticketRegistry);
    }

    protected Event doExecute(RequestContext requestContext) throws Exception {
        Principal principal = this.authenticationSupport.getAuthenticatedPrincipalFrom(WebUtils.getTicketGrantingTicketId((RequestContext)requestContext));
        if (principal == null) {
            logger.warn("The SSO session is no longer valid. Restarting the login process...");
            return this.error();
        }
        Map principalAttributes = principal.getAttributes();
        String principalId = principal.getId();
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        String serviceId = service.getId();
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        if (registeredService == null) {
            logger.warn("Unauthorized Service Access for Service: [ {} ] - service is not defined in the service registry.", (Object)serviceId);
            throw new UnauthorizedServiceException();
        }
        if (!registeredService.isEnabled()) {
            logger.warn("Unauthorized Service Access for Service: [ {} ] - service is not enabled in the service registry.", (Object)serviceId);
            throw new UnauthorizedServiceException();
        }
        if (!(registeredService instanceof RegisteredServiceWithAttributes)) {
            logger.info("Service [{}] is not configured for role-based authorization", (Object)registeredService);
            return null;
        }
        RegisteredServiceWithAttributes registeredServiceWithAttributes = (RegisteredServiceWithAttributes)registeredService;
        Object serviceAttributes = registeredServiceWithAttributes.getExtraAttributes().get(AUTHZ_ATTRS_KEY);
        if (serviceAttributes == null) {
            logger.info("Service [{}] is not configured for role-based authorization", (Object)registeredServiceWithAttributes.getServiceId());
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("SERVICE [%s] ATTRIBUTES: %s | PRINCIPAL [%s] ATTRIBUTES: %s", registeredServiceWithAttributes.getServiceId(), serviceAttributes, principalId, principalAttributes));
            }
            if (!this.authorizer.authorized(serviceAttributes, principalAttributes)) {
                logger.info("Principal [{}] is not authorized to use service [{}]", (Object)principalId, (Object)serviceId);
                requestContext.getRequestScope().put(AUTHZ_FAIL_REDIRECT_URL_KEY, registeredServiceWithAttributes.getExtraAttributes().get(ATTR_URL_KEY));
                throw new RoleBasedServiceAuthorizationException();
            }
            logger.info("Principal [{}] is authorized to use service [{}]", (Object)principalId, (Object)serviceId);
        }
        return null;
    }
}

