/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.support;

import java.net.URI;
import org.apache.shiro.crypto.hash.Sha1Hash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.io.Resource;

public class ResourceChangeDetectingEventNotifier
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;
    private final Resource watchedResource;
    private volatile String resourceSha1Hex;
    private static final Logger logger = LoggerFactory.getLogger(ResourceChangeDetectingEventNotifier.class);
    private static final String EMPTY_STRING_SHA1 = "da39a3ee5e6b4b0d3255bfef95601890afd80709";

    public ResourceChangeDetectingEventNotifier(Resource watchedResource) throws Exception {
        this.watchedResource = watchedResource;
        if (!this.watchedResource.exists()) {
            throw new BeanCreationException(String.format("The 'watchedResource' [%s] must point to an existing resource. Please double-check that such resource exists.", this.watchedResource.getURI()));
        }
        String initialSha1Hex = new Sha1Hash((Object)this.watchedResource.getFile()).toHex();
        if (EMPTY_STRING_SHA1.equals(initialSha1Hex)) {
            logger.warn("The 'watchedResource' [{}] is empty!", (Object)this.watchedResource.getURI());
        }
        this.resourceSha1Hex = initialSha1Hex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfTheResourceChangeEventIfNecessary() {
        block5: {
            String currentResourceSha1 = this.resourceSha1Hex;
            String newResourceSha1 = null;
            try {
                newResourceSha1 = new Sha1Hash((Object)this.watchedResource.getFile()).toHex();
                if (newResourceSha1.equals(currentResourceSha1)) break block5;
                logger.debug("Resource: [{}] | Old Hash: [{}] | New Hash: [{}]", new Object[]{this.watchedResource.getURI(), currentResourceSha1, newResourceSha1});
                String string = this.resourceSha1Hex;
                synchronized (string) {
                    this.resourceSha1Hex = newResourceSha1;
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new ResourceChangedEvent(this, this.watchedResource.getURI()));
                }
            }
            catch (Throwable e) {
                logger.error("An exception is caught during 'watchedResource' access", e);
                return;
            }
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public static class ResourceChangedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 1L;
        private final URI resourceUri;

        public ResourceChangedEvent(Object source, URI resourceUri) {
            super(source);
            this.resourceUri = resourceUri;
        }

        public URI getResourceUri() {
            return this.resourceUri;
        }
    }
}

