/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.ticket.expiration;

import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.unicon.cas.addons.ticket.expiration.TicketExpirationPolicyEvaluator;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.TicketState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class CompositeTicketGrantingTicketExpirationPolicy
implements ExpirationPolicy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 3021175146846182330L;
    private final Map<TicketExpirationPolicyEvaluator, ExpirationPolicy> evaluators;
    private ExpirationPolicy defaultExpirationPolicy = new AlwaysExpiresExpirationPolicy();

    public CompositeTicketGrantingTicketExpirationPolicy(Map<TicketExpirationPolicyEvaluator, ExpirationPolicy> evaluators) {
        this.evaluators = evaluators;
    }

    public final void setDefaultExpirationPolicy(ExpirationPolicy def) {
        this.defaultExpirationPolicy = def;
    }

    public final boolean isExpired(TicketState state) {
        Set<TicketExpirationPolicyEvaluator> keys = this.evaluators.keySet();
        for (TicketExpirationPolicyEvaluator eval : keys) {
            if (!eval.doesSatisfyTicketExpirationPolicy(this.getRequest(), state)) continue;
            this.logger.debug("Expiration policy evaluator [{}] satisfies this request", (Object)eval);
            ExpirationPolicy policy = this.evaluators.get(eval);
            boolean expired = policy.isExpired(state);
            this.logger.debug("Delegated to mapped expiration policy [{}], which indicates the ticket has " + (expired ? "" : "not ") + "expired", (Object)policy);
            return expired;
        }
        this.logger.debug("Delegated to default expiration policy [{}]", (Object)this.defaultExpirationPolicy);
        return this.defaultExpirationPolicy.isExpired(state);
    }

    private HttpServletRequest getRequest() {
        ServletRequestAttributes attrs = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        return attrs.getRequest();
    }

    private class AlwaysExpiresExpirationPolicy
    implements ExpirationPolicy {
        private static final long serialVersionUID = -5505383542873474014L;

        private AlwaysExpiresExpirationPolicy() {
        }

        public boolean isExpired(TicketState ticketState) {
            CompositeTicketGrantingTicketExpirationPolicy.this.logger.debug("Ticket is ALWAYS considered expired.");
            return true;
        }
    }
}

