/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.ticket.expiration;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.unicon.cas.addons.ticket.expiration.TicketExpirationPolicyEvaluator;
import org.apache.http.conn.util.InetAddressUtils;
import org.jasig.cas.ticket.TicketState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpAddressBasedExpirationPolicyEvaluator
implements TicketExpirationPolicyEvaluator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Pattern ipAddressPattern;

    public IpAddressBasedExpirationPolicyEvaluator(String ipPattern) {
        this.ipAddressPattern = Pattern.compile(ipPattern);
    }

    @Override
    public boolean doesSatisfyTicketExpirationPolicy(HttpServletRequest request, TicketState state) {
        String currentIp = request.getRemoteAddr();
        if (InetAddressUtils.isIPv6Address((String)currentIp)) {
            this.logger.debug("Remote IP [{}] is a valid standard (non-compressed) IPv6 address", (Object)currentIp);
        } else if (InetAddressUtils.isIPv6HexCompressedAddress((String)currentIp)) {
            this.logger.debug("Remote IP [{}] is a valid IPv6 address (including compressed).", (Object)currentIp);
        } else if (InetAddressUtils.isIPv6StdAddress((String)currentIp)) {
            this.logger.debug("Remote IP [{}] is a valid compressed IPv6 address", (Object)currentIp);
        } else if (InetAddressUtils.isIPv4Address((String)currentIp)) {
            this.logger.debug("Remote IP [{}] is a valid IPv4 address ", (Object)currentIp);
        } else {
            this.logger.debug("Remote IP [{}] does not match a known IP syntax", (Object)currentIp);
        }
        return this.ipAddressPattern.matcher(currentIp).find();
    }
}

