/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.ticket.internal;

import java.util.ArrayList;
import java.util.List;
import net.unicon.cas.addons.support.ThreadSafe;
import net.unicon.cas.addons.ticket.BulkRetrievalOfTicketsNotSupportedException;
import net.unicon.cas.addons.ticket.TicketSupport;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ThreadSafe
@Component
public class DefaultTicketSupport
implements TicketSupport {
    private final TicketRegistry ticketRegistry;

    @Autowired
    public DefaultTicketSupport(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    @Override
    public boolean ticketGrantingTicketExistsAndExpired(String ticketGrantingTicketId) {
        Ticket ticket = this.ticketRegistry.getTicket(ticketGrantingTicketId);
        if (ticket != null && ticket instanceof TicketGrantingTicket) {
            return ((TicketGrantingTicket)TicketGrantingTicket.class.cast(ticket)).isExpired();
        }
        return false;
    }

    @Override
    public void deleteExpiredTicketGrantingTicket(String ticketGrantingTicketId) {
        if (this.ticketGrantingTicketExistsAndExpired(ticketGrantingTicketId)) {
            this.ticketRegistry.deleteTicket(ticketGrantingTicketId);
        }
    }

    @Override
    public List<TicketGrantingTicket> getNonExpiredTicketGrantingTickets() throws BulkRetrievalOfTicketsNotSupportedException {
        ArrayList<TicketGrantingTicket> tgts = new ArrayList<TicketGrantingTicket>();
        try {
            for (Ticket ticket : this.ticketRegistry.getTickets()) {
                if (!(ticket instanceof TicketGrantingTicket) || ticket.isExpired()) continue;
                tgts.add((TicketGrantingTicket)ticket);
            }
        }
        catch (UnsupportedOperationException e) {
            throw new BulkRetrievalOfTicketsNotSupportedException("The underlying implementation of <TicketRegistry> does not support a bulk retrieval of tickets", e);
        }
        return tgts;
    }
}

