/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.ticket.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.util.DefaultLongNumericGenerator;
import org.jasig.cas.util.DefaultRandomStringGenerator;
import org.jasig.cas.util.NumericGenerator;
import org.jasig.cas.util.RandomStringGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HostNameBasedUniqueTicketIdGenerator
implements UniqueTicketIdGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostNameBasedUniqueTicketIdGenerator.class);
    private final NumericGenerator numericGenerator = new DefaultLongNumericGenerator(1L);
    private final RandomStringGenerator randomStringGenerator;
    private String suffix;

    public HostNameBasedUniqueTicketIdGenerator() {
        this(null);
    }

    public HostNameBasedUniqueTicketIdGenerator(int maxLength) {
        this(maxLength, null);
    }

    public HostNameBasedUniqueTicketIdGenerator(String suffix) {
        this.randomStringGenerator = new DefaultRandomStringGenerator();
        this.prepareTicketSuffix(suffix);
    }

    public HostNameBasedUniqueTicketIdGenerator(int maxLength, String suffix) {
        this.randomStringGenerator = new DefaultRandomStringGenerator(maxLength);
        this.prepareTicketSuffix(suffix);
    }

    public String getNewTicketId(String prefix) {
        String number = this.numericGenerator.getNextNumberAsString();
        StringBuilder buffer = new StringBuilder(prefix.length() + 2 + (this.suffix != null ? this.suffix.length() : 0) + this.randomStringGenerator.getMaxLength() + number.length());
        buffer.append(prefix);
        buffer.append("-");
        buffer.append(number);
        buffer.append("-");
        buffer.append(this.randomStringGenerator.getNewString());
        if (this.suffix != null) {
            buffer.append(this.suffix);
        }
        return buffer.toString();
    }

    private void prepareTicketSuffix(String suffix) {
        this.suffix = null;
        if (StringUtils.isEmpty((String)suffix)) {
            try {
                String hostName = InetAddress.getLocalHost().getCanonicalHostName();
                this.suffix = hostName.indexOf(".") > 0 ? hostName.substring(0, hostName.indexOf(".")) : hostName;
                LOGGER.debug("Automatically determined ticket suffix to be [{}].", (Object)this.suffix);
            }
            catch (UnknownHostException e) {
                LOGGER.debug("Host name could not be determined automatically for the ticket suffix.", (Throwable)e);
            }
        } else {
            this.suffix = "-" + suffix;
        }
    }
}

