/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.ticket.registry;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastTicketRegistry
extends AbstractDistributedTicketRegistry {
    private final IMap<String, Ticket> ticketsMap;
    private static final Logger logger = LoggerFactory.getLogger(HazelcastTicketRegistry.class);
    private final long serviceTicketTimeoutInSeconds;
    private final long ticketGrantingTicketTimeoutInSeconds;

    public HazelcastTicketRegistry(HazelcastInstance hz, long ticketGrantingTicketTimeoutInSeconds, long serviceTicketTimeoutInSeconds) {
        logger.info("Constructing TicketRegistry from HazelcastInstance: {}", (Object)hz);
        logger.info("TicketGrantingTicket timeout is used for Hazelcast TGT entries (in seconds): [{}]", (Object)ticketGrantingTicketTimeoutInSeconds);
        logger.info("ServiceTicket timeout is used for Hazelcast ST entries (in seconds): [{}]", (Object)serviceTicketTimeoutInSeconds);
        this.ticketsMap = hz.getMap("tickets");
        this.ticketGrantingTicketTimeoutInSeconds = ticketGrantingTicketTimeoutInSeconds;
        this.serviceTicketTimeoutInSeconds = serviceTicketTimeoutInSeconds;
    }

    protected void updateTicket(Ticket ticket) {
        this.addTicket(ticket);
    }

    public void addTicket(Ticket ticket) {
        long ticketTimeout = this.getTimeout(ticket);
        logger.debug("Adding Ticket[{}] to the Hazelcast IMap with a TTL of [{}] seconds", (Object)ticket.getId(), (Object)ticketTimeout);
        this.ticketsMap.set((Object)ticket.getId(), (Object)ticket, this.getTimeout(ticket), TimeUnit.SECONDS);
    }

    public Ticket getTicket(String ticketId) {
        Ticket t = (Ticket)this.ticketsMap.get((Object)ticketId);
        logger.debug("Returning Ticket[{}] from the Hazelcast IMap", (Object)(t == null ? "null" : t.getId()));
        return t == null ? null : this.getProxiedTicketInstance(t);
    }

    public boolean deleteTicket(String ticketId) {
        logger.debug("Removing Ticket[{}] from the Hazelcast IMap", (Object)ticketId);
        return this.ticketsMap.remove((Object)ticketId) != null;
    }

    public Collection<Ticket> getTickets() {
        return this.ticketsMap.values();
    }

    protected boolean needsCallback() {
        return false;
    }

    private long getTimeout(Ticket t) {
        if (t instanceof TicketGrantingTicket) {
            return this.ticketGrantingTicketTimeoutInSeconds;
        }
        if (t instanceof ServiceTicket) {
            return this.serviceTicketTimeoutInSeconds;
        }
        throw new IllegalArgumentException("Invalid ticket type");
    }
}

