/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.web.flow;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.unicon.cas.addons.serviceregistry.RegisteredServiceWithAttributes;
import net.unicon.cas.addons.web.flow.ServiceRedirectionAdvisor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public final class InMemoryServiceRedirectionByClientIpAddressAdvisor
implements ServiceRedirectionAdvisor {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryServiceRedirectionByClientIpAddressAdvisor.class);
    private final Set<String> repository = new HashSet<String>();

    @Override
    public boolean shouldRedirectServiceRequest(RequestContext context, RegisteredServiceWithAttributes service, String redirectUrl) {
        String key = this.buildKey(context, service, redirectUrl);
        if (this.repository.contains(key)) {
            logger.info("Request [{}] has fulfilled redirection requirements for service id [{}]", (Object)key, (Object)service.getServiceId());
            return false;
        }
        logger.info("Before granting authentication request for [{}], request must be redirected to [{}].", (Object)key, (Object)redirectUrl);
        return this.repository.add(key);
    }

    private String buildKey(RequestContext context, RegisteredServiceWithAttributes service, String redirectUrl) {
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getNativeRequest();
        return String.valueOf(request.getRemoteAddr()) + "-" + request.getRemotePort() + "-" + service.hashCode() + "-" + redirectUrl;
    }
}

