/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.web.flow;

import javax.validation.constraints.NotNull;
import net.unicon.cas.addons.serviceregistry.RegisteredServiceWithAttributes;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class ServiceAuthorizationCheckWithCustomView
extends AbstractAction {
    @NotNull
    private final ServicesManager servicesManager;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String DISABLED_SERVICE_URL_ATTRIBUTE = "disabledServiceUrl";

    public ServiceAuthorizationCheckWithCustomView(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        if (service == null) {
            return this.success();
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        if (registeredService == null) {
            this.logger.warn("Unauthorized Service Access for Service: [ {} ] - service is not defined in the service registry.", (Object)service.getId());
            throw new UnauthorizedServiceException();
        }
        if (!registeredService.isEnabled()) {
            String disabledServiceUrl;
            this.logger.warn("Unauthorized Service Access for Service: [ {} ] - service is not enabled in the service registry.", (Object)service.getId());
            if (registeredService instanceof RegisteredServiceWithAttributes && (disabledServiceUrl = (String)((RegisteredServiceWithAttributes)RegisteredServiceWithAttributes.class.cast(registeredService)).getExtraAttributes().get(DISABLED_SERVICE_URL_ATTRIBUTE)) != null) {
                context.getRequestScope().put(DISABLED_SERVICE_URL_ATTRIBUTE, (Object)disabledServiceUrl);
                return this.no();
            }
            throw new UnauthorizedServiceException();
        }
        return this.success();
    }
}

