/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.web.flow;

import javax.validation.constraints.NotNull;
import net.unicon.cas.addons.serviceregistry.RegisteredServiceWithAttributes;
import net.unicon.cas.addons.web.flow.InMemoryServiceRedirectionByClientIpAddressAdvisor;
import net.unicon.cas.addons.web.flow.ServiceRedirectionAdvisor;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class ServiceRedirectionAction
extends AbstractAction {
    @NotNull
    private final ServicesManager servicesManager;
    private static final Logger logger = LoggerFactory.getLogger(ServiceRedirectionAction.class);
    private static final String REDIRECT_TO_URL_ATTRIBUTE = "redirectToUrl";
    private ServiceRedirectionAdvisor redirectionAdvisor = new InMemoryServiceRedirectionByClientIpAddressAdvisor();

    public ServiceRedirectionAction(@NotNull ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setRedirectionAdvisor(@NotNull ServiceRedirectionAdvisor advisor) {
        this.redirectionAdvisor = advisor;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        RegisteredServiceWithAttributes regSvcWithAttr;
        String redirectToUrl;
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        if (service == null) {
            logger.debug("No service found in the request context, so resuming normally.");
            return this.success();
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        if (registeredService == null) {
            logger.warn("Unauthorized Service Access for Service: [{}] - service is not defined in the service registry.", (Object)service.getId());
            throw new UnauthorizedServiceException();
        }
        if (!registeredService.isEnabled()) {
            logger.warn("Unauthorized Service Access for Service: [{}] - service is not enabled in the service registry.", (Object)service.getId());
            throw new UnauthorizedServiceException();
        }
        if (registeredService instanceof RegisteredServiceWithAttributes && (redirectToUrl = (String)(regSvcWithAttr = (RegisteredServiceWithAttributes)RegisteredServiceWithAttributes.class.cast(registeredService)).getExtraAttributes().get(REDIRECT_TO_URL_ATTRIBUTE)) != null && this.redirectionAdvisor.shouldRedirectServiceRequest(context, regSvcWithAttr, redirectToUrl)) {
            logger.info("Redirecting to url [{}] for service [{}]", (Object)redirectToUrl, (Object)service.getId());
            context.getRequestScope().put(REDIRECT_TO_URL_ATTRIBUTE, (Object)redirectToUrl);
            return this.yes();
        }
        logger.debug("No redirect url is configured, or redirection for service [{}] is not needed", (Object)service.getId());
        return this.success();
    }
}

