/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addons.web.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.unicon.cas.addons.serviceregistry.RegisteredServiceWithAttributes;
import net.unicon.cas.addons.serviceregistry.services.RegisteredServicesPolicies;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.web.ServiceValidateController;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;

public class SsoDestroyingServiceValidateController
extends ServiceValidateController
implements InitializingBean {
    private TicketRegistry ticketRegistry;
    private CentralAuthenticationService cas;
    private ServicesManager servicesManager;
    private ArgumentExtractor argExtractor;
    private RegisteredServicesPolicies registeredServicesPolicies;
    private static final ThreadLocal<TicketGrantingTicket> tgtHolder = new ThreadLocal();

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public void setCas(CentralAuthenticationService cas) {
        this.cas = cas;
        super.setCentralAuthenticationService(cas);
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setArgExtractor(ArgumentExtractor argExtractor) {
        this.argExtractor = argExtractor;
        super.setArgumentExtractor(argExtractor);
    }

    public void setRegisteredServicesPolicies(RegisteredServicesPolicies registeredServicesPolicies) {
        this.registeredServicesPolicies = registeredServicesPolicies;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.ticketRegistry, (String)"ticketRegistry is required");
        Assert.notNull((Object)this.cas, (String)"cas is required");
        Assert.notNull((Object)this.servicesManager, (String)"servicesManager is required");
        Assert.notNull((Object)this.argExtractor, (String)"argExtractor is required");
        Assert.notNull((Object)this.registeredServicesPolicies, (String)"registeredServicesPolicies is required");
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebApplicationService service = this.argExtractor.extractService(request);
        if (service == null) {
            return super.handleRequest(request, response);
        }
        Ticket st = this.ticketRegistry.getTicket(service.getArtifactId());
        if (st == null) {
            return super.handleRequest(request, response);
        }
        tgtHolder.set(st.getGrantingTicket());
        return super.handleRequest(request, response);
    }

    protected void onSuccessfulValidation(String serviceTicketId, Assertion assertion) {
        try {
            RegisteredServiceWithAttributes registeredService = (RegisteredServiceWithAttributes)RegisteredServiceWithAttributes.class.cast(this.servicesManager.findServiceBy(assertion.getService()));
            if (!this.registeredServicesPolicies.ssoSessionInitiating(registeredService)) {
                this.cas.destroyTicketGrantingTicket(tgtHolder.get().getId());
            }
        }
        finally {
            tgtHolder.remove();
        }
    }
}

