/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.WSDL20DefaultValueHolder;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.neethi.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisBindingOperation
extends AxisDescription {
    private AxisOperation axisOperation;
    private QName name;
    private Map<String, AxisBindingMessage> faults;
    private Map<String, Object> options = new HashMap<String, Object>();

    public AxisBindingOperation() {
        this.faults = new HashMap<String, AxisBindingMessage>();
    }

    public ArrayList<AxisBindingMessage> getFaults() {
        return new ArrayList<AxisBindingMessage>(this.faults.values());
    }

    public AxisBindingMessage getFault(String name) {
        return this.faults.get(name);
    }

    public void addFault(AxisBindingMessage fault) {
        this.faults.put(fault.getName(), fault);
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public AxisOperation getAxisOperation() {
        return this.axisOperation;
    }

    public void setAxisOperation(AxisOperation axisOperation) {
        this.axisOperation = axisOperation;
    }

    public void setProperty(String name, Object value) {
        this.options.put(name, value);
    }

    public Object getProperty(String name) {
        AxisBinding parent;
        Object property = this.options.get(name);
        if (property == null && (parent = this.getAxisBinding()) != null) {
            property = parent.getProperty(name);
        }
        if (property == null) {
            property = WSDL20DefaultValueHolder.getDefaultValue(name);
        }
        return property;
    }

    @Override
    public Object getKey() {
        return this.name;
    }

    @Override
    public void engageModule(AxisModule axisModule) throws AxisFault {
        throw new UnsupportedOperationException("Sorry we do not support this");
    }

    @Override
    public boolean isEngaged(String moduleName) {
        throw new UnsupportedOperationException("axisMessage.isEngaged() is not supported");
    }

    public OMElement toWSDL20(OMNamespace wsdl, OMNamespace tns, OMNamespace wsoap, OMNamespace whttp, String type, Map<String, String> namespaceMap, String serviceName) {
        AxisBindingMessage outMessage;
        AxisBindingMessage inMessage;
        String property;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement bindingOpElement = omFactory.createOMElement("operation", wsdl);
        bindingOpElement.addAttribute(omFactory.createOMAttribute("ref", null, tns.getPrefix() + ":" + this.name.getLocalPart()));
        if ("http://www.w3.org/ns/wsdl/soap".equals(type) || "http://schemas.xmlsoap.org/soap/http".equals(type) || "http://www.w3.org/2003/05/http".equals(type)) {
            ArrayList soapModules;
            property = (String)this.options.get("wsoap:action");
            if (property != null) {
                bindingOpElement.addAttribute(omFactory.createOMAttribute("action", wsoap, property));
            }
            if ((soapModules = (ArrayList)this.options.get("wsoap:module")) != null && soapModules.size() > 0) {
                WSDLSerializationUtil.addSOAPModuleElements(omFactory, soapModules, wsoap, bindingOpElement);
            }
            if ((property = (String)this.options.get("wsoap:mep")) != null) {
                bindingOpElement.addAttribute(omFactory.createOMAttribute("mep", wsoap, property));
            }
        } else if ("http://www.w3.org/ns/wsdl/http".equals(type)) {
            Boolean ignoreUncited;
            property = (String)this.options.get("whttp:inputSerialization");
            if (property != null) {
                bindingOpElement.addAttribute(omFactory.createOMAttribute("inputSerialization", whttp, property));
            }
            if ((property = (String)this.options.get("whttp:outputSerialization")) != null) {
                bindingOpElement.addAttribute(omFactory.createOMAttribute("outputSerialization", whttp, property));
            }
            if ((property = (String)this.options.get("whttp:faultSerialization")) != null) {
                bindingOpElement.addAttribute(omFactory.createOMAttribute("faultSerialization", whttp, property));
            }
            if ((ignoreUncited = (Boolean)this.options.get("whttp:ignoreUncited")) != null) {
                bindingOpElement.addAttribute(omFactory.createOMAttribute("ignoreUncited", whttp, ignoreUncited.toString()));
            }
            if ((property = (String)this.options.get("whttp:method")) != null) {
                bindingOpElement.addAttribute(omFactory.createOMAttribute("method", whttp, property));
            }
        }
        property = (String)this.options.get("whttp:location");
        if (property != null) {
            bindingOpElement.addAttribute(omFactory.createOMAttribute("location", whttp, property));
        }
        if ((property = (String)this.options.get("whttp:contentEncoding")) != null) {
            bindingOpElement.addAttribute(omFactory.createOMAttribute("contentEncoding", whttp, property));
        }
        if ((property = (String)this.options.get("whttp:queryParameterSeparator")) != null) {
            bindingOpElement.addAttribute(omFactory.createOMAttribute("queryParameterSeparator", whttp, property));
        }
        if ((inMessage = (AxisBindingMessage)this.getChild("In")) != null) {
            bindingOpElement.addChild((OMNode)inMessage.toWSDL20(wsdl, tns, wsoap, whttp, namespaceMap));
        }
        if ((outMessage = (AxisBindingMessage)this.getChild("Out")) != null) {
            bindingOpElement.addChild((OMNode)outMessage.toWSDL20(wsdl, tns, wsoap, whttp, namespaceMap));
        }
        if (this.faults != null && this.faults.size() > 0) {
            Collection<AxisBindingMessage> faultValues = this.faults.values();
            for (AxisBindingMessage faultMessage : faultValues) {
                bindingOpElement.addChild((OMNode)faultMessage.toWSDL20(wsdl, tns, wsoap, whttp, namespaceMap));
            }
        }
        WSDLSerializationUtil.addWSDLDocumentationElement(this, bindingOpElement, omFactory, wsdl);
        WSDLSerializationUtil.addPoliciesAsExtensibleElement(this, bindingOpElement);
        return bindingOpElement;
    }

    public Policy getEffectivePolicy() {
        Policy axisOperationPolicy;
        ArrayList<Policy> policyList = new ArrayList<Policy>();
        PolicyInclude policyInclude = this.getPolicyInclude();
        policyList.addAll(policyInclude.getAttachedPolicies());
        AxisBinding axisBinding = this.getAxisBinding();
        if (axisBinding != null) {
            policyList.addAll(axisBinding.getPolicyInclude().getAttachedPolicies());
        }
        AxisEndpoint axisEndpoint = null;
        if (axisBinding != null) {
            axisEndpoint = axisBinding.getAxisEndpoint();
        }
        if (axisEndpoint != null) {
            policyList.addAll(axisEndpoint.getPolicyInclude().getAttachedPolicies());
        }
        if ((axisOperationPolicy = this.axisOperation.getPolicyInclude().getEffectivePolicy()) != null) {
            policyList.add(axisOperationPolicy);
        }
        return PolicyUtil.getMergedPolicy(policyList, this);
    }

    public AxisBinding getAxisBinding() {
        return (AxisBinding)this.parent;
    }
}

