/*
 * $Id$
 */

package org.apache.maven.lifecycle.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A binding of one mojo to one lifecycle phase, possibly including
 * configuration.
 * 
 * @version $Revision$ $Date$
 */
public class MojoBinding implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Plugin's groupId.
     */
    private String groupId;

    /**
     * Plugin's artifactId.
     */
    private String artifactId;

    /**
     * Plugin's version.
     */
    private String version;

    /**
     * Mojo's goal name.
     */
    private String goal;

    /**
     * A name for this mojo binding, for purposes of merging
     * configurations via inheritance, etc.
     */
    private String executionId = "default";

    /**
     * Mojo binding's configuration.
     */
    private Object configuration;

    /**
     * Marks a mojo binding as optional (not required for execution
     * of the lifecycle).
     */
    private boolean optional = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other)
        {
            return true;
        }
    
        if ( !(other instanceof MojoBinding) )
        {
            return false;
        }
    
        MojoBinding that = (MojoBinding) other;
        boolean result = true;
    
        result = result && ( getGroupId() == null ? that.getGroupId() == null : getGroupId().equals( that.getGroupId() ) );
        result = result && ( getArtifactId() == null ? that.getArtifactId() == null : getArtifactId().equals( that.getArtifactId() ) );
        result = result && ( getGoal() == null ? that.getGoal() == null : getGoal().equals( that.getGoal() ) );
        result = result && ( getExecutionId() == null ? that.getExecutionId() == null : getExecutionId().equals( that.getExecutionId() ) );
    
        return result;
    } //-- boolean equals( Object ) 

    /**
     * Get plugin's artifactId.
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get mojo binding's configuration.
     * 
     * @return Object
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration() 

    /**
     * Get a name for this mojo binding, for purposes of merging
     * configurations via inheritance, etc.
     * 
     * @return String
     */
    public String getExecutionId()
    {
        return this.executionId;
    } //-- String getExecutionId() 

    /**
     * Get mojo's goal name.
     * 
     * @return String
     */
    public String getGoal()
    {
        return this.goal;
    } //-- String getGoal() 

    /**
     * Get plugin's groupId.
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get plugin's version.
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
    
        result = 37 * result + ( groupId != null ? groupId.hashCode() : 0 );
        result = 37 * result + ( artifactId != null ? artifactId.hashCode() : 0 );
        result = 37 * result + ( goal != null ? goal.hashCode() : 0 );
        result = 37 * result + ( executionId != null ? executionId.hashCode() : 0 );
    
        return result;
    } //-- int hashCode() 

    /**
     * Get marks a mojo binding as optional (not required for
     * execution of the lifecycle).
     * 
     * @return boolean
     */
    public boolean isOptional()
    {
        return this.optional;
    } //-- boolean isOptional() 

    /**
     * Set plugin's artifactId.
     * 
     * @param artifactId
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String ) 

    /**
     * Set mojo binding's configuration.
     * 
     * @param configuration
     */
    public void setConfiguration( Object configuration )
    {
        this.configuration = configuration;
    } //-- void setConfiguration( Object ) 

    /**
     * Set a name for this mojo binding, for purposes of merging
     * configurations via inheritance, etc.
     * 
     * @param executionId
     */
    public void setExecutionId( String executionId )
    {
        this.executionId = executionId;
    } //-- void setExecutionId( String ) 

    /**
     * Set mojo's goal name.
     * 
     * @param goal
     */
    public void setGoal( String goal )
    {
        this.goal = goal;
    } //-- void setGoal( String ) 

    /**
     * Set plugin's groupId.
     * 
     * @param groupId
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String ) 

    /**
     * Set marks a mojo binding as optional (not required for
     * execution of the lifecycle).
     * 
     * @param optional
     */
    public void setOptional( boolean optional )
    {
        this.optional = optional;
    } //-- void setOptional( boolean ) 

    /**
     * Set plugin's version.
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String ) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
    
        buf.append( "groupId = '" );
        buf.append( getGroupId() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "artifactId = '" );
        buf.append( getArtifactId() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "goal = '" );
        buf.append( getGoal() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "executionId = '" );
        buf.append( getExecutionId() );
        buf.append( "'" );
    
        return buf.toString();
    } //-- java.lang.String toString() 


    /** origin marker for mojos referenced directly by the user or embedded-mode consumer. */
    public static final String DIRECT_INVOCATION_ORIGIN = "Direct invocation";
    
    /** origin marker for single (non-lifecycle) mojos referenced by a forked-execution annotation in another mojo. */
    public static final String FORKED_DIRECT_REFERENCE_ORIGIN = "Direct forking reference";
    
    /** origin marker for mojos bound to the lifecycle through POM configuration (not packaging defaults). */
    public static final String POM_ORIGIN = "POM";
    
    /** origin marker for mojos bound to the lifecycle by a standard (or default) lifecycle mapping. */
    public static final String LIFECYCLE_MAPPING_ORIGIN = "Lifecycle mapping";
    
    /** origin marker for mojos injected into the lifecycle by Maven, to manage lifecycle state. */
    public static final String INTERNAL_ORIGIN = "Maven internal state-management";
    
    private String origin;
    
    /**
     * Return the origin marker set for this MojoBinding, or null. This will give a general idea of where this
     * binding came from.
     */
    public String getOrigin()
    {
        return origin;
    }
    
    public void setOrigin( String origin )
    {
        this.origin = origin;
    }
    
    private String originDescription;
    
    /**
     * Return specific information about where exactly this binding came from, if it's available. 
     * This might be used to record the specific forking mojo or the lifecycle
     * overlay name that included this mojo, for instance.
     */
    public String getOriginDescription()
    {
        return originDescription;
    }
    
    public void setOriginDescription( String originDescription )
    {
        this.originDescription = originDescription;
    }
          
    private Phase phase;
    
    /**
     * Get the Phase instance to which this MojoBinding is bound. NOTE: In
     * some cases, the phase name may not be known, or may not exist (as in the
     * case of a direct mojo invocation from the command line or embedder).
     */
    public Phase getPhase()
    {
        return phase;
    }
    
    /**
     * Set the Phase instance to which this MojoBinding is bound.
     */
    public void setLifecycleInfo( Phase phase )
    {
        this.phase = phase;
    }
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
