/*
 * $Id$
 */

package org.apache.maven.lifecycle.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import org.apache.maven.lifecycle.model.BuildBinding;
import org.apache.maven.lifecycle.model.CleanBinding;
import org.apache.maven.lifecycle.model.LifecycleBinding;
import org.apache.maven.lifecycle.model.LifecycleBindings;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.lifecycle.model.Phase;
import org.apache.maven.lifecycle.model.SiteBinding;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class LifecycleBindingsXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class LifecycleBindingsXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE.
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write.
     * 
     * @param writer
     * @param lifecycleBindings
     * @throws java.io.IOException
     */
    public void write( Writer writer, LifecycleBindings lifecycleBindings )
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( lifecycleBindings.getModelEncoding(), null );
        writeLifecycleBindings( lifecycleBindings, "lifecycles", serializer );
        serializer.endDocument();
    } //-- void write( Writer, LifecycleBindings ) 

    /**
     * Method writeBuildBinding.
     * 
     * @param buildBinding
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeBuildBinding( BuildBinding buildBinding, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( buildBinding != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( buildBinding.getValidate() != null )
            {
                writePhase( (Phase) buildBinding.getValidate(), "validate", serializer );
            }
            if ( buildBinding.getInitialize() != null )
            {
                writePhase( (Phase) buildBinding.getInitialize(), "initialize", serializer );
            }
            if ( buildBinding.getGenerateSources() != null )
            {
                writePhase( (Phase) buildBinding.getGenerateSources(), "generate-sources", serializer );
            }
            if ( buildBinding.getProcessSources() != null )
            {
                writePhase( (Phase) buildBinding.getProcessSources(), "process-sources", serializer );
            }
            if ( buildBinding.getGenerateResources() != null )
            {
                writePhase( (Phase) buildBinding.getGenerateResources(), "generate-resources", serializer );
            }
            if ( buildBinding.getProcessResources() != null )
            {
                writePhase( (Phase) buildBinding.getProcessResources(), "process-resources", serializer );
            }
            if ( buildBinding.getCompile() != null )
            {
                writePhase( (Phase) buildBinding.getCompile(), "compile", serializer );
            }
            if ( buildBinding.getProcessClasses() != null )
            {
                writePhase( (Phase) buildBinding.getProcessClasses(), "process-classes", serializer );
            }
            if ( buildBinding.getGenerateTestSources() != null )
            {
                writePhase( (Phase) buildBinding.getGenerateTestSources(), "generate-test-sources", serializer );
            }
            if ( buildBinding.getProcessTestSources() != null )
            {
                writePhase( (Phase) buildBinding.getProcessTestSources(), "process-test-sources", serializer );
            }
            if ( buildBinding.getGenerateTestResources() != null )
            {
                writePhase( (Phase) buildBinding.getGenerateTestResources(), "generate-test-resources", serializer );
            }
            if ( buildBinding.getProcessTestResources() != null )
            {
                writePhase( (Phase) buildBinding.getProcessTestResources(), "process-test-resources", serializer );
            }
            if ( buildBinding.getTestCompile() != null )
            {
                writePhase( (Phase) buildBinding.getTestCompile(), "test-compile", serializer );
            }
            if ( buildBinding.getProcessTestClasses() != null )
            {
                writePhase( (Phase) buildBinding.getProcessTestClasses(), "process-test-classes", serializer );
            }
            if ( buildBinding.getTest() != null )
            {
                writePhase( (Phase) buildBinding.getTest(), "test", serializer );
            }
            if ( buildBinding.getPreparePackage() != null )
            {
                writePhase( (Phase) buildBinding.getPreparePackage(), "prepare-package", serializer );
            }
            if ( buildBinding.getCreatePackage() != null )
            {
                writePhase( (Phase) buildBinding.getCreatePackage(), "package", serializer );
            }
            if ( buildBinding.getPreIntegrationTest() != null )
            {
                writePhase( (Phase) buildBinding.getPreIntegrationTest(), "pre-integration-test", serializer );
            }
            if ( buildBinding.getIntegrationTest() != null )
            {
                writePhase( (Phase) buildBinding.getIntegrationTest(), "integration-test", serializer );
            }
            if ( buildBinding.getPostIntegrationTest() != null )
            {
                writePhase( (Phase) buildBinding.getPostIntegrationTest(), "post-integration-test", serializer );
            }
            if ( buildBinding.getVerify() != null )
            {
                writePhase( (Phase) buildBinding.getVerify(), "verify", serializer );
            }
            if ( buildBinding.getInstall() != null )
            {
                writePhase( (Phase) buildBinding.getInstall(), "install", serializer );
            }
            if ( buildBinding.getDeploy() != null )
            {
                writePhase( (Phase) buildBinding.getDeploy(), "deploy", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeBuildBinding( BuildBinding, String, XmlSerializer ) 

    /**
     * Method writeCleanBinding.
     * 
     * @param cleanBinding
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeCleanBinding( CleanBinding cleanBinding, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( cleanBinding != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( cleanBinding.getPreClean() != null )
            {
                writePhase( (Phase) cleanBinding.getPreClean(), "pre-clean", serializer );
            }
            if ( cleanBinding.getClean() != null )
            {
                writePhase( (Phase) cleanBinding.getClean(), "clean", serializer );
            }
            if ( cleanBinding.getPostClean() != null )
            {
                writePhase( (Phase) cleanBinding.getPostClean(), "post-clean", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeCleanBinding( CleanBinding, String, XmlSerializer ) 

    /**
     * Method writeLifecycleBinding.
     * 
     * @param lifecycleBinding
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeLifecycleBinding( LifecycleBinding lifecycleBinding, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( lifecycleBinding != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeLifecycleBinding( LifecycleBinding, String, XmlSerializer ) 

    /**
     * Method writeLifecycleBindings.
     * 
     * @param lifecycleBindings
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeLifecycleBindings( LifecycleBindings lifecycleBindings, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( lifecycleBindings != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( lifecycleBindings.getPackaging() != null )
            {
                serializer.startTag( NAMESPACE, "packaging" ).text( lifecycleBindings.getPackaging() ).endTag( NAMESPACE, "packaging" );
            }
            if ( lifecycleBindings.getCleanBinding() != null )
            {
                writeCleanBinding( (CleanBinding) lifecycleBindings.getCleanBinding(), "clean", serializer );
            }
            if ( lifecycleBindings.getBuildBinding() != null )
            {
                writeBuildBinding( (BuildBinding) lifecycleBindings.getBuildBinding(), "build", serializer );
            }
            if ( lifecycleBindings.getSiteBinding() != null )
            {
                writeSiteBinding( (SiteBinding) lifecycleBindings.getSiteBinding(), "site", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeLifecycleBindings( LifecycleBindings, String, XmlSerializer ) 

    /**
     * Method writeMojoBinding.
     * 
     * @param mojoBinding
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeMojoBinding( MojoBinding mojoBinding, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( mojoBinding != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( mojoBinding.getGroupId() != null )
            {
                serializer.startTag( NAMESPACE, "groupId" ).text( mojoBinding.getGroupId() ).endTag( NAMESPACE, "groupId" );
            }
            if ( mojoBinding.getArtifactId() != null )
            {
                serializer.startTag( NAMESPACE, "artifactId" ).text( mojoBinding.getArtifactId() ).endTag( NAMESPACE, "artifactId" );
            }
            if ( mojoBinding.getVersion() != null )
            {
                serializer.startTag( NAMESPACE, "version" ).text( mojoBinding.getVersion() ).endTag( NAMESPACE, "version" );
            }
            if ( mojoBinding.getGoal() != null )
            {
                serializer.startTag( NAMESPACE, "goal" ).text( mojoBinding.getGoal() ).endTag( NAMESPACE, "goal" );
            }
            if ( mojoBinding.getExecutionId() != null && !mojoBinding.getExecutionId().equals( "default" ) )
            {
                serializer.startTag( NAMESPACE, "executionId" ).text( mojoBinding.getExecutionId() ).endTag( NAMESPACE, "executionId" );
            }
            if ( mojoBinding.getConfiguration() != null )
            {
                ((Xpp3Dom) mojoBinding.getConfiguration()).writeToSerializer( NAMESPACE, serializer );
            }
            if ( mojoBinding.isOptional() != false )
            {
                serializer.startTag( NAMESPACE, "optional" ).text( String.valueOf( mojoBinding.isOptional() ) ).endTag( NAMESPACE, "optional" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeMojoBinding( MojoBinding, String, XmlSerializer ) 

    /**
     * Method writePhase.
     * 
     * @param phase
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writePhase( Phase phase, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( phase != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( phase.getBindings() != null && phase.getBindings().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "bindings" );
                for ( Iterator iter = phase.getBindings().iterator(); iter.hasNext(); )
                {
                    MojoBinding o = (MojoBinding) iter.next();
                    writeMojoBinding( o, "binding", serializer );
                }
                serializer.endTag( NAMESPACE, "bindings" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writePhase( Phase, String, XmlSerializer ) 

    /**
     * Method writeSiteBinding.
     * 
     * @param siteBinding
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeSiteBinding( SiteBinding siteBinding, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( siteBinding != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( siteBinding.getPreSite() != null )
            {
                writePhase( (Phase) siteBinding.getPreSite(), "pre-site", serializer );
            }
            if ( siteBinding.getSite() != null )
            {
                writePhase( (Phase) siteBinding.getSite(), "site", serializer );
            }
            if ( siteBinding.getPostSite() != null )
            {
                writePhase( (Phase) siteBinding.getPostSite(), "post-site", serializer );
            }
            if ( siteBinding.getSiteDeploy() != null )
            {
                writePhase( (Phase) siteBinding.getSiteDeploy(), "site-deploy", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeSiteBinding( SiteBinding, String, XmlSerializer ) 


}
