/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.fractal.plugin.docbook.clean;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public class CleanMojo
extends AbstractMojo {
    private MavenProject project;
    private File docbookDirectory;
    private File xdocDirectory;
    private boolean verbose;
    private List filesets;
    private boolean followSymLinks;
    private FileSetManager fileSetManager;
    private boolean skip;
    private boolean failOnError;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Clean is skipped.");
            return;
        }
        try {
            this.fileSetManager = new FileSetManager(this.getLog(), this.verbose);
            this.removeFiles(this.docbookDirectory, this.xdocDirectory);
        }
        catch (MojoExecutionException e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().warn((CharSequence)e.getMessage());
        }
    }

    private void removeFiles(File docbookDir, File xdocDir) throws MojoExecutionException {
        this.getLog().info((CharSequence)("docbook directory : " + docbookDir));
        this.getLog().info((CharSequence)("xdoc directory : " + xdocDir));
        if (docbookDir != null && this.xdocDirectory != null) {
            if (!docbookDir.exists()) {
                return;
            }
            if (!this.xdocDirectory.exists()) {
                return;
            }
            if (!docbookDir.isDirectory()) {
                throw new MojoExecutionException(docbookDir + " is not a directory.");
            }
            if (!this.xdocDirectory.isDirectory()) {
                throw new MojoExecutionException(this.xdocDirectory + " is not a directory.");
            }
            FileSet fs = new FileSet();
            fs.setDirectory(docbookDir.getPath());
            fs.addInclude("**/*.dbk");
            fs.setFollowSymlinks(false);
            String[] files = this.fileSetManager.getIncludedFiles(fs);
            FileSet fsToRemove = new FileSet();
            fsToRemove.setDirectory(xdocDir.getPath());
            fsToRemove.setFollowSymlinks(false);
            for (int i = 0; i < files.length; ++i) {
                File file = new File(this.xdocDirectory.getPath() + File.separator + files[i].replace(".dbk", ".xml"));
                if (file.exists() && !file.getName().startsWith(".")) {
                    this.getLog().info((CharSequence)(file.getAbsolutePath() + " will be deleted."));
                    file.delete();
                    continue;
                }
                this.getLog().info((CharSequence)(file.getAbsolutePath() + " doesn't exist."));
            }
            try {
                this.getLog().info((CharSequence)"Deleting files ");
            }
            catch (IllegalStateException e) {
                throw new MojoExecutionException("Failed to delete files. Reason: " + e.getMessage(), (Exception)e);
            }
        }
    }

    protected void setXdocDirectory(File newXdocDirectory) {
        this.xdocDirectory = newXdocDirectory;
    }

    protected void setDocbookDirectory(File newDocbookDirectory) {
        this.docbookDirectory = newDocbookDirectory;
    }
}

