/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public abstract class AbstractEffectiveMojo
extends AbstractHelpMojo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeXmlFile(File output, String content) throws IOException {
        if (output == null) {
            return;
        }
        XmlStreamWriter out = null;
        try {
            output.getParentFile().mkdirs();
            out = WriterFactory.newXmlWriter((File)output);
            out.write(content);
            out.close();
            out = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((Writer)out);
    }

    protected static void writeHeader(XMLWriter writer) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        String formattedDateTime = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.format(System.currentTimeMillis());
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)("Generated by Maven Help Plugin on " + formattedDateTime));
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"See: http://maven.apache.org/plugins/maven-help-plugin/");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
    }

    protected static void writeComment(XMLWriter writer, String comment) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)comment);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
    }

    protected static String prettyFormat(String effectiveModel, String encoding, boolean omitDeclaration) {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document effectiveDocument = builder.build((Reader)new StringReader(effectiveModel));
            StringWriter w = new StringWriter();
            Format format = Format.getPrettyFormat();
            if (encoding != null) {
                format.setEncoding(encoding);
            }
            format.setLineSeparator(System.lineSeparator());
            format.setOmitDeclaration(omitDeclaration);
            XMLOutputter out = new XMLOutputter(format);
            out.output(effectiveDocument, (Writer)w);
            return w.toString();
        }
        catch (JDOMException e) {
            return effectiveModel;
        }
        catch (IOException e) {
            return effectiveModel;
        }
    }

    protected static class SortedProperties
    extends Properties {
        static final long serialVersionUID = -8985316072702233744L;

        protected SortedProperties() {
        }

        @Override
        public Set<Object> keySet() {
            Set<Object> keynames = super.keySet();
            ArrayList<Object> list = new ArrayList<Object>(keynames);
            Collections.sort(list);
            return new LinkedHashSet<Object>(list);
        }
    }
}

