/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.apps.mailreader.dao.impl.memory;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.apps.mailreader.dao.Subscription;
import org.apache.struts.apps.mailreader.dao.User;
import org.apache.struts.apps.mailreader.dao.UserDatabase;
import org.apache.struts.apps.mailreader.dao.impl.memory.MemorySubscriptionCreationFactory;
import org.apache.struts.apps.mailreader.dao.impl.memory.MemoryUser;
import org.apache.struts.apps.mailreader.dao.impl.memory.MemoryUserCreationFactory;

public class MemoryUserDatabase
implements UserDatabase {
    private Log log = LogFactory.getLog(this.getClass());
    private HashMap users = new HashMap();
    private boolean open = false;
    private String pathname = null;
    private String pathnameOld = null;
    private String pathnameNew = null;

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
        this.pathnameOld = pathname + ".old";
        this.pathnameNew = pathname + ".new";
    }

    public void close() throws Exception {
        this.save();
        this.open = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User createUser(String username) {
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            if (this.users.get(username) != null) {
                throw new IllegalArgumentException("Duplicate user '" + username + "'");
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Creating user '" + username + "'"));
            }
            MemoryUser user = new MemoryUser(this, username);
            HashMap hashMap2 = this.users;
            synchronized (hashMap2) {
                this.users.put(username, user);
            }
            return user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUser(String username) {
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            return (User)this.users.get(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User[] findUsers() {
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            User[] results = new User[this.users.size()];
            return this.users.values().toArray(results);
        }
    }

    public void open() throws Exception {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading database from '" + this.pathname + "'"));
            }
            fis = new FileInputStream(this.pathname);
            bis = new BufferedInputStream(fis);
            Digester digester = new Digester();
            digester.push((Object)this);
            digester.setValidating(false);
            digester.addFactoryCreate("database/user", (ObjectCreationFactory)new MemoryUserCreationFactory(this));
            digester.addFactoryCreate("database/user/subscription", (ObjectCreationFactory)new MemorySubscriptionCreationFactory());
            digester.parse((InputStream)bis);
            bis.close();
            bis = null;
            fis = null;
            this.open = true;
        }
        catch (Exception e) {
            this.log.error((Object)("Loading database from '" + this.pathname + "':"), (Throwable)e);
            throw e;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Throwable throwable) {}
                bis = null;
                fis = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(User user) {
        if (this != user.getDatabase()) {
            throw new IllegalArgumentException("User not associated with this database");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Removing user '" + user.getUsername() + "'"));
        }
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            this.users.remove(user.getUsername());
        }
    }

    public void save() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving database to '" + this.pathname + "'"));
        }
        File fileNew = new File(this.pathnameNew);
        PrintWriter writer = null;
        try {
            FileOutputStream fos = new FileOutputStream(fileNew);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            writer = new PrintWriter(osw);
            writer.println("<?xml version='1.0'?>");
            writer.println("<database>");
            User[] yusers = this.findUsers();
            for (int i = 0; i < yusers.length; ++i) {
                writer.print("  ");
                writer.println(yusers[i]);
                Subscription[] subscriptions = yusers[i].getSubscriptions();
                for (int j = 0; j < subscriptions.length; ++j) {
                    writer.print("    ");
                    writer.println(subscriptions[j]);
                    writer.print("    ");
                    writer.println("</subscription>");
                }
                writer.print("  ");
                writer.println("</user>");
            }
            writer.println("</database>");
            if (writer.checkError()) {
                writer.close();
                fileNew.delete();
                throw new IOException("Saving database to '" + this.pathname + "'");
            }
            writer.close();
            writer = null;
        }
        catch (IOException e) {
            if (writer != null) {
                writer.close();
            }
            fileNew.delete();
            throw e;
        }
        File fileOrig = new File(this.pathname);
        File fileOld = new File(this.pathnameOld);
        if (fileOrig.exists()) {
            fileOld.delete();
            if (!fileOrig.renameTo(fileOld)) {
                throw new IOException("Renaming '" + this.pathname + "' to '" + this.pathnameOld + "'");
            }
        }
        if (!fileNew.renameTo(fileOrig)) {
            if (fileOld.exists()) {
                fileOld.renameTo(fileOrig);
            }
            throw new IOException("Renaming '" + this.pathnameNew + "' to '" + this.pathname + "'");
        }
        fileOld.delete();
    }

    public boolean isOpen() {
        return this.open;
    }
}

