/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.gmavenplus.javaparser.LanguageLevel;
import org.codehaus.gmavenplus.model.GroovyDocConfiguration;
import org.codehaus.gmavenplus.model.IncludeClasspath;
import org.codehaus.gmavenplus.model.Link;
import org.codehaus.gmavenplus.model.Scopes;
import org.codehaus.gmavenplus.model.internal.Version;
import org.codehaus.gmavenplus.mojo.AbstractGroovySourcesMojo;
import org.codehaus.gmavenplus.util.FileUtils;
import org.codehaus.gmavenplus.util.GroovyCompiler;

public abstract class AbstractGroovyDocMojo
extends AbstractGroovySourcesMojo {
    protected static final Version GROOVY_1_6_0_RC1 = new Version(1, 6, 0, "RC-1");
    protected static final Version GROOVY_1_5_8 = new Version(1, 5, 8);
    @Parameter(defaultValue="Groovy Documentation")
    protected String windowTitle;
    @Parameter(defaultValue="Groovy Documentation")
    protected String docTitle;
    @Parameter(defaultValue="Groovy Documentation")
    protected String footer;
    @Parameter
    protected LanguageLevel languageLevel;
    @Parameter(defaultValue="Groovy Documentation")
    protected String header;
    @Parameter(defaultValue="true")
    protected boolean displayAuthor;
    @Parameter
    protected File overviewFile;
    @Parameter
    protected File stylesheetFile;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String stylesheetEncoding;
    @Parameter(defaultValue="private")
    protected String scope;
    @Parameter
    protected List<Link> links;
    @Parameter(property="skipGroovydoc", defaultValue="false")
    protected boolean skipGroovyDoc;
    @Parameter(defaultValue="PROJECT_ONLY")
    protected IncludeClasspath includeClasspath;
    @Parameter
    protected String[] defaultDocTemplates = null;
    @Parameter
    protected String[] defaultPackageTemplates = null;
    @Parameter
    protected String[] defaultClassTemplates = null;
    @Parameter
    protected String groovyDocToolClass = null;
    @Parameter
    protected String outputToolClass = null;
    @Parameter
    protected String fileOutputToolClass = null;
    @Parameter
    protected String resourceManagerClass = null;
    @Parameter
    protected String classpathResourceManagerClass = null;
    @Parameter
    protected String linkArgumentClass = null;
    @Parameter(defaultValue="false")
    protected boolean attachGroovyDocAnnotation;
    @Inject
    protected ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="fork", defaultValue="false")
    protected boolean fork;

    protected synchronized void doGroovyDocGeneration(FileSet[] sourceDirectories, List<?> classpath, File outputDirectory) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException, MalformedURLException {
        if (this.skipGroovyDoc) {
            this.getLog().info((CharSequence)"Skipping generation of GroovyDoc because ${skipGroovydoc} was set to true.");
            return;
        }
        if (sourceDirectories == null || sourceDirectories.length == 0) {
            this.getLog().info((CharSequence)"No source directories specified for GroovyDoc generation. Skipping.");
            return;
        }
        GroovyDocConfiguration configuration = new GroovyDocConfiguration(sourceDirectories, classpath, outputDirectory);
        configuration.setIncludeClasspath(this.includeClasspath);
        configuration.setDocProperties(this.setupProperties());
        configuration.setLinks(this.links);
        configuration.setAttachGroovyDocAnnotation(this.attachGroovyDocAnnotation);
        configuration.setDefaultDocTemplates(this.defaultDocTemplates);
        configuration.setDefaultPackageTemplates(this.defaultPackageTemplates);
        configuration.setDefaultClassTemplates(this.defaultClassTemplates);
        configuration.setGroovyDocToolClass(this.groovyDocToolClass);
        configuration.setOutputToolClass(this.outputToolClass);
        configuration.setFileOutputToolClass(this.fileOutputToolClass);
        configuration.setResourceManagerClass(this.resourceManagerClass);
        configuration.setClasspathResourceManagerClass(this.classpathResourceManagerClass);
        configuration.setLinkArgumentClass(this.linkArgumentClass);
        configuration.setWindowTitle(this.windowTitle);
        configuration.setDocTitle(this.docTitle);
        configuration.setFooter(this.footer);
        configuration.setHeader(this.header);
        configuration.setDisplayAuthor(this.displayAuthor);
        configuration.setDisplayAuthor(this.displayAuthor);
        configuration.setOverviewFile(this.overviewFile);
        configuration.setLanguageLevel(this.languageLevel != null ? this.languageLevel.toString() : null);
        configuration.setScope(this.scope);
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (toolchain != null) {
            this.getLog().info((CharSequence)("Toolchain in gmavenplus-plugin: " + toolchain));
            this.performForkedGroovyDocGeneration(configuration, toolchain.findTool("java"));
        } else if (this.fork) {
            String javaExecutable = this.getJavaExecutable();
            this.getLog().info((CharSequence)("Forking GroovyDoc generation using " + javaExecutable));
            this.performForkedGroovyDocGeneration(configuration, javaExecutable);
        } else {
            this.performInProcessGroovyDocGeneration(configuration);
        }
        if (this.stylesheetFile != null) {
            this.copyStylesheet(outputDirectory);
        }
    }

    protected void performInProcessGroovyDocGeneration(GroovyDocConfiguration configuration) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException, MalformedURLException {
        this.setupClassWrangler(configuration.getClasspath(), this.includeClasspath);
        this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
        this.logPluginClasspath();
        if (!this.groovyVersionSupportsAction()) {
            this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support GroovyDoc. The minimum version of Groovy required is " + this.minGroovyVersion + ". Skipping GroovyDoc generation."));
            return;
        }
        if (this.groovyIs(GROOVY_1_6_0_RC1) || this.groovyIs(GROOVY_1_5_8)) {
            this.getLog().warn((CharSequence)("Groovy " + GROOVY_1_5_8 + " and " + GROOVY_1_6_0_RC1 + " are blacklisted from the supported GroovyDoc versions because of their dependency on Ant. Skipping GroovyDoc generation."));
            return;
        }
        GroovyCompiler compiler = new GroovyCompiler(this.classWrangler, this.getLog());
        compiler.generateGroovyDoc(configuration);
    }

    protected void performForkedGroovyDocGeneration(GroovyDocConfiguration configuration, String javaExecutable) throws InvocationTargetException {
        try {
            File configFile = File.createTempFile("groovy-doc-config", ".ser");
            configFile.deleteOnExit();
            try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(configFile.toPath(), new OpenOption[0]));){
                oos.writeObject(configuration);
            }
            String forkClasspath = this.buildForkClasspath();
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaExecutable);
            command.add("-cp");
            command.add(forkClasspath);
            command.add("org.codehaus.gmavenplus.util.ForkedGroovyCompiler");
            command.add(configFile.getAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.inheritIO();
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new InvocationTargetException(new RuntimeException("Forked GroovyDoc generation failed with exit code " + exitCode));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected String buildForkClasspath() {
        StringBuilder cp = new StringBuilder();
        cp.append(this.pluginDescriptor.getPluginArtifact().getFile().getAbsolutePath());
        for (Artifact artifact : this.pluginDescriptor.getArtifacts()) {
            cp.append(File.pathSeparator);
            cp.append(artifact.getFile().getAbsolutePath());
        }
        try {
            Class<Log> logClass = Log.class;
            CodeSource codeSource = logClass.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                String logJar = new File(codeSource.getLocation().toURI()).getAbsolutePath();
                cp.append(File.pathSeparator).append(logJar);
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Could not find maven-plugin-api jar to add to fork classpath", (Throwable)e);
        }
        return cp.toString();
    }

    protected Properties setupProperties() {
        Properties properties = new Properties();
        properties.setProperty("windowTitle", this.windowTitle);
        properties.setProperty("docTitle", this.docTitle);
        properties.setProperty("footer", this.footer);
        properties.setProperty("header", this.header);
        properties.setProperty("author", Boolean.toString(this.displayAuthor));
        properties.setProperty("overviewFile", this.overviewFile != null ? this.overviewFile.getAbsolutePath() : "");
        try {
            Scopes scopeVal = Scopes.valueOf(this.scope.toUpperCase());
            if (scopeVal.equals((Object)Scopes.PUBLIC)) {
                properties.setProperty("publicScope", "true");
            } else if (scopeVal.equals((Object)Scopes.PROTECTED)) {
                properties.setProperty("protectedScope", "true");
            } else if (scopeVal.equals((Object)Scopes.PACKAGE)) {
                properties.setProperty("packageScope", "true");
            } else if (scopeVal.equals((Object)Scopes.PRIVATE)) {
                properties.setProperty("privateScope", "true");
            }
        }
        catch (IllegalArgumentException e) {
            this.getLog().warn((CharSequence)("Scope (" + this.scope + ") was not recognized. Skipping argument."));
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyStylesheet(File outputDirectory) {
        this.getLog().info((CharSequence)("Using stylesheet from " + this.stylesheetFile.getAbsolutePath() + "."));
        try {
            BufferedReader bufferedReader = null;
            BufferedWriter bufferedWriter = null;
            try {
                String line;
                bufferedReader = this.stylesheetEncoding != null ? new BufferedReader(new InputStreamReader(Files.newInputStream(this.stylesheetFile.toPath(), new OpenOption[0]), this.stylesheetEncoding)) : new BufferedReader(new InputStreamReader(Files.newInputStream(this.stylesheetFile.toPath(), new OpenOption[0])));
                StringBuilder css = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    css.append(line).append("\n");
                }
                File outfile = new File(outputDirectory, "stylesheet.css");
                bufferedWriter = this.stylesheetEncoding != null ? new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(outfile.toPath(), new OpenOption[0]), this.stylesheetEncoding)) : new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(outfile.toPath(), new OpenOption[0])));
                bufferedWriter.write(css.toString());
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(bufferedReader);
                FileUtils.closeQuietly(bufferedWriter);
                throw throwable;
            }
            FileUtils.closeQuietly(bufferedReader);
            FileUtils.closeQuietly(bufferedWriter);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to copy specified stylesheet (" + this.stylesheetFile.getAbsolutePath() + ")."));
        }
    }
}

